/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingBuilder;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GroupRoleMapping
extends RoleMapping {
    private static final Logger LOG = LoggerFactory.getLogger(GroupRoleMapping.class);
    private final String roleArn;
    private final String[] groupnames;

    private GroupRoleMapping(String roleArn, String[] groupnames) {
        this.roleArn = roleArn;
        this.groupnames = groupnames;
    }

    @Override
    boolean appliesTo(RoleMappingContext context) {
        FileSystemOwner fileSystemOwner = context.getFileSystemOwner();
        if (fileSystemOwner == null) {
            return false;
        }
        for (String userGroup : fileSystemOwner.getGroupNames()) {
            for (String mappingGroup : this.groupnames) {
                if (!userGroup.equals(mappingGroup)) continue;
                LOG.debug("Matching {} : {} with {}", new Object[]{this, mappingGroup, fileSystemOwner});
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isValid() {
        return GroupRoleMapping.isRoleArnValid(this.roleArn) && this.groupnames.length > 0 && Arrays.stream(this.groupnames).map(g -> !g.isEmpty()).reduce(true, Boolean::logicalAnd) != false;
    }

    @Override
    String getRoleArn() {
        return this.roleArn;
    }

    @Override
    String[] getTargets() {
        return this.groupnames;
    }

    @Override
    RoleMappingType getType() {
        return RoleMappingType.GROUP;
    }

    static GroupRoleMappingBuilder builder() {
        return new GroupRoleMappingBuilder();
    }

    static class GroupRoleMappingBuilder
    extends RoleMappingBuilder {
        private GroupRoleMappingBuilder() {
        }

        @Override
        GroupRoleMapping build() {
            return new GroupRoleMapping(super.getRoleArn(), super.getTargets());
        }
    }
}

