/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.property;

import java.util.Arrays;
import javax.annotation.Nullable;

public enum RetryPolicyType {
    EXPONENTIAL("exponential"),
    FAST_FIRST_RETRY_EXPONENTIAL("fastFirstRetryExponential"),
    FIXED("fixed"),
    FAST_FIRST_RETRY_FIXED("fastFirstRetryFixed"),
    NONE("none");

    private static final String LOWER_CASE_NAMES;
    private final String policyTypeName;

    private RetryPolicyType(String policyTypeName) {
        this.policyTypeName = policyTypeName;
    }

    public static String getNamesAsString() {
        return LOWER_CASE_NAMES;
    }

    @Nullable
    public static RetryPolicyType fromName(@Nullable String name) {
        for (RetryPolicyType retryPolicyType : RetryPolicyType.values()) {
            if (!retryPolicyType.policyTypeName.equals(name)) continue;
            return retryPolicyType;
        }
        return null;
    }

    public String getName() {
        return this.policyTypeName;
    }

    public String toString() {
        return this.policyTypeName;
    }

    static {
        LOWER_CASE_NAMES = Arrays.toString((Object[])RetryPolicyType.values());
    }
}

