/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.property;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public enum AwsS3SignerType {
    SIGV2("S3SignerType"),
    SIGV4("AWSS3V4SignerType");

    private final String name;

    private AwsS3SignerType(String name) {
        this.name = name;
    }

    @Nullable
    public static String fromName(String type) {
        for (AwsS3SignerType signerType : AwsS3SignerType.values()) {
            if (!signerType.getName().equals(type)) continue;
            return type;
        }
        return null;
    }

    public static List<String> getNames() {
        ArrayList<String> names = Lists.newArrayList();
        for (AwsS3SignerType signerType : AwsS3SignerType.values()) {
            names.add(signerType.getName());
        }
        return names;
    }

    public static boolean isValidName(String name) {
        return AwsS3SignerType.fromName(name) != null;
    }

    public String getName() {
        return this.name;
    }
}

