/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.notification;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.GsonBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParser;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQSManager {
    private static final Logger LOG = LoggerFactory.getLogger(SQSManager.class);
    private final AmazonSQS amazonSQS;
    private final int batchSize;
    private final int pullWaitTimeSeconds;
    private final String url;

    public SQSManager(AmazonSQS amazonSQS, Configuration configuration, String queueName) {
        this.amazonSQS = amazonSQS;
        this.batchSize = configuration.getInt("fs.s3.consistent.notification.SQS.batchSize", 10);
        this.pullWaitTimeSeconds = configuration.getInt("fs.s3.consistent.notification.SQS.pullWaitTimeSeconds", 3);
        GetQueueUrlRequest getQueueUrlRequest = new GetQueueUrlRequest(queueName);
        GetQueueUrlResult getQueueUrlResult = this.amazonSQS.getQueueUrl(getQueueUrlRequest);
        this.url = getQueueUrlResult.getQueueUrl();
    }

    public List<Message> pull() {
        return this.pull(-1);
    }

    public List<Message> pull(int visibilityTimeoutSeconds) {
        ReceiveMessageResult result;
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(this.url).withMaxNumberOfMessages(this.batchSize).withWaitTimeSeconds(this.pullWaitTimeSeconds);
        if (visibilityTimeoutSeconds >= 0) {
            receiveMessageRequest.setVisibilityTimeout(visibilityTimeoutSeconds);
        }
        return (result = this.amazonSQS.receiveMessage(receiveMessageRequest)) == null ? new ArrayList() : result.getMessages();
    }

    public void delete(List<Message> messages) {
        ArrayList<DeleteMessageBatchRequestEntry> deleteRequests = new ArrayList<DeleteMessageBatchRequestEntry>();
        HashSet<String> ids = new HashSet<String>();
        for (Message m : messages) {
            if (ids.contains(m.getMessageId())) continue;
            ids.add(m.getMessageId());
            deleteRequests.add(new DeleteMessageBatchRequestEntry().withId(m.getMessageId()).withReceiptHandle(m.getReceiptHandle()));
        }
        LOG.debug(String.format("Deleting %s messages", deleteRequests.size()));
        DeleteMessageBatchRequest batchDelete = new DeleteMessageBatchRequest().withQueueUrl(this.url).withEntries(deleteRequests);
        this.amazonSQS.deleteMessageBatch(batchDelete);
    }

    public void deleteQueue() {
        try {
            DeleteQueueRequest deleteQueueRequest = new DeleteQueueRequest(this.url);
            this.amazonSQS.deleteQueue(deleteQueueRequest);
        }
        catch (AmazonClientException e) {
            LOG.error("Failed to delete queue: {}", (Object)this.url, (Object)e);
        }
    }

    public void purge() {
        try {
            List<Message> messages;
            while (!(messages = this.pull()).isEmpty()) {
                this.delete(messages);
            }
        }
        catch (AmazonClientException e) {
            LOG.error("Failed to purge SQS queue: {}", (Object)this.url, (Object)e);
        }
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(String filePath) {
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            } else if (!file.isFile()) {
                LOG.error("Failed to dump SQS, path {} is not a file", (Object)file);
            }
            try (PrintStream printStream = new PrintStream(new FileOutputStream(file));){
                this.dump(printStream);
            }
        }
        catch (IOException e) {
            LOG.error("Exception occurred while open file: {}", (Object)file, (Object)e);
        }
    }

    private void dump(PrintStream printStream) {
        int VISIBILITY_TIMEOUT = 60;
        boolean loggedOnce = false;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jsonParser = new JsonParser();
        try {
            List<Message> messages;
            System.setOut(printStream);
            DateTime visibilityTimeout = DateTime.now().plusSeconds(60);
            while (!(messages = this.pull(60)).isEmpty()) {
                if (DateTime.now().isAfter(visibilityTimeout) && !loggedOnce) {
                    LOG.warn("SQS visibility timeout ({} seconds) exceeded, possibly getting duplicated messages", (Object)60);
                    loggedOnce = true;
                }
                for (Message m : messages) {
                    try {
                        printStream.append(gson.toJson(jsonParser.parse(m.getBody())) + "\n");
                    }
                    catch (JsonParseException e) {
                        printStream.append(m.getBody() + "\n");
                    }
                }
            }
        }
        catch (AmazonClientException e) {
            LOG.error("Exception occurred while dumping SQS queue: {}", (Object)this.url, (Object)e);
        }
    }
}

