/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.notification;

import com.amazon.ws.emr.hadoop.fs.notification.AbstractSQSMessage;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class InconsistencySQSMessage
extends AbstractSQSMessage {
    private List<String> inconsistentPaths;
    private boolean truncated;
    private int numInconsistentPaths;

    public InconsistencySQSMessage(Configuration configuration, Notifier.Api api, Path arg1, Path arg2, List<Path> inconsistentPaths) {
        super(configuration, api, arg1, arg2);
        this.numInconsistentPaths = inconsistentPaths.size();
        this.inconsistentPaths = InconsistencySQSMessage.truncateIfNeeded(inconsistentPaths, configuration);
        this.truncated = this.numInconsistentPaths > this.inconsistentPaths.size();
    }

    private static List<String> truncateIfNeeded(List<Path> paths, Configuration conf) {
        return paths.stream().limit(InconsistencySQSMessage.getPathReportLimit(conf)).map(Path::toString).collect(Collectors.toList());
    }

    private static int getPathReportLimit(Configuration conf) {
        return conf.getInt("fs.s3.consistent.notification.SQS.pathReportLimit", 10);
    }

    public List<String> getInconsistentPaths() {
        return this.inconsistentPaths;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public int getNumInconsistentPaths() {
        return this.numInconsistentPaths;
    }
}

