/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.notification;

import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchNotifier
implements Notifier {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchNotifier.class);
    private final AmazonCloudWatch cloudWatch;
    private final String jobFlowId;

    public CloudWatchNotifier(AmazonCloudWatch cloudWatch, String jobFlowId) {
        this.cloudWatch = cloudWatch;
        this.jobFlowId = jobFlowId;
    }

    private void sendOneDataPoint(String metricName, Notifier.Api api, double value) {
        MetricDatum datum = new MetricDatum();
        datum.setMetricName(metricName);
        HashSet<Dimension> dimensions = new HashSet<Dimension>();
        dimensions.add(new Dimension().withName("JobFlowId").withValue(this.jobFlowId));
        dimensions.add(new Dimension().withName("API").withValue(api.toString()));
        datum.setDimensions(dimensions);
        datum.setUnit(StandardUnit.Count);
        datum.setValue(value);
        PutMetricDataRequest request = new PutMetricDataRequest();
        request.setNamespace("EMRFS");
        request.setMetricData(Collections.singleton(datum));
        try {
            this.cloudWatch.putMetricData(request);
        }
        catch (Exception e) {
            LOG.warn("Failed to send {} notification", (Object)metricName, (Object)e);
        }
    }

    @Override
    public void inconsistency(Notifier.Api api, Path arg1, Path arg2, List<Path> inconsistentPaths) {
        this.sendOneDataPoint("Inconsistency", api, 1.0);
    }
}

