/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.identity;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemOwner
implements FileSystemOwner {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileSystemOwner.class);
    private final UserGroupInformation underlyingUserGroupInformation;

    public HadoopFileSystemOwner(UserGroupInformation ugi) {
        Preconditions.checkNotNull(ugi);
        this.underlyingUserGroupInformation = ugi;
    }

    @Override
    public String getFullUserName() {
        return this.underlyingUserGroupInformation.getUserName();
    }

    @Override
    public String getShortUserName() {
        return this.underlyingUserGroupInformation.getShortUserName();
    }

    @Override
    public String getGroup() {
        try {
            return this.underlyingUserGroupInformation.getPrimaryGroupName();
        }
        catch (IOException ioe) {
            LOG.warn("found no group information for {}, using {} as primary group", (Object)this.underlyingUserGroupInformation, (Object)this.getFullUserName());
            return this.getFullUserName();
        }
    }

    @Override
    public String[] getGroupNames() {
        return this.underlyingUserGroupInformation.getGroupNames();
    }

    public String toString() {
        return this.underlyingUserGroupInformation.toString();
    }
}

