/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.NativeDynamoDBEntityStore;
import com.amazon.ws.emr.hadoop.fs.guice.AWSCredentialsProviderFactory;
import com.amazon.ws.emr.hadoop.fs.guice.DefaultAWSCredentialsProviderFactory;
import com.amazon.ws.emr.hadoop.fs.guice.DynamoDBRetryCondition;
import com.amazon.ws.emr.hadoop.fs.guice.EmrFSBaseModule;
import com.amazon.ws.emr.hadoop.fs.guice.S3CallOverridesGetter;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.notification.CloudWatchNotifier;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.notification.SQSNotifier;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3LiteClientFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3LiteClients;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3Configuration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.configuration.S3EncryptionConfiguration;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.S3CallOverrider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.ClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.retry.RetryPolicy;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Provides;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.name.Named;
import com.amazon.ws.emr.hadoop.fs.util.ClientConfigurationFactory;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class EmrFSProdModule
extends EmrFSBaseModule {
    public static final String NON_ENCRYPT_S3_NAME = "NonEncryptS3";
    private final ClientConfigurationFactory clientConfigurationFactory;
    private final AmazonS3LiteClientFactory clientFactory = AmazonS3LiteClients.defaultFactory();
    private final AWSCredentialsProviderFactory credsProviderFactory = new DefaultAWSCredentialsProviderFactory();

    public EmrFSProdModule(URI uri, Configuration configuration) {
        super(uri, configuration);
        this.clientConfigurationFactory = new ClientConfigurationFactory(this.provideFileSystemOwner(), configuration, null);
    }

    @Override
    protected void configure() {
        super.configure();
    }

    @Override
    protected AWSCredentialsProvider getAwsCredentialsProvider(String service) {
        return this.credsProviderFactory.getAwsCredentialsProvider(service, this.uri, this.configuration);
    }

    @Override
    protected AWSCredentialsProvider getAwsCredentialsProvider() {
        return this.credsProviderFactory.getAwsCredentialsProvider("s3", this.uri, this.configuration);
    }

    private AmazonS3Lite createAmazonS3LiteClient(FileSystemOwner fileSystemOwner) {
        AWSCredentialsProvider credentialsProvider = this.getAwsCredentialsProvider("s3");
        return this.clientFactory.newClient(this.createS3Configuration(credentialsProvider), this.createS3ConfigurationInitialTimeoutOnlyIfSet(credentialsProvider), EmrFsUtils.getS3Endpoint(this.configuration), this.getS3CallOverriders(fileSystemOwner));
    }

    private S3Configuration createS3Configuration(AWSCredentialsProvider credentialsProvider) {
        return (S3Configuration)((S3Configuration.Builder)((S3Configuration.Builder)S3Configuration.builder().awsCredentialsProvider(credentialsProvider)).clientConfiguration(this.clientConfigurationFactory.getClientConfiguration("s3", null))).build();
    }

    private S3Configuration createS3ConfigurationInitialTimeoutOnlyIfSet(AWSCredentialsProvider credentialsProvider) {
        ClientConfiguration clientConfiguration = this.clientConfigurationFactory.getClientConfigurationInitialTimeoutOnlyIfSet("s3", null);
        if (clientConfiguration == null) {
            return null;
        }
        return (S3Configuration)((S3Configuration.Builder)((S3Configuration.Builder)S3Configuration.builder().awsCredentialsProvider(credentialsProvider)).clientConfiguration(clientConfiguration)).build();
    }

    private AmazonS3EncryptionLite createAmazonS3EncryptionLiteClient(FileSystemOwner fileSystemOwner) {
        AWSCredentialsProvider credentialsProvider = this.getAwsCredentialsProvider("s3");
        EncryptionMaterialsProvider encryptionMaterialsProvider = this.getEncryptionMaterialsProvider();
        return this.clientFactory.newEncryptionClient(this.createS3EncryptionConfiguration(credentialsProvider, encryptionMaterialsProvider), this.createS3EncryptionConfigurationInitialTimeoutOnlyIfSet(credentialsProvider, encryptionMaterialsProvider), EmrFsUtils.getS3Endpoint(this.configuration), this.getS3CallOverriders(fileSystemOwner));
    }

    private S3EncryptionConfiguration createS3EncryptionConfiguration(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        return (S3EncryptionConfiguration)((S3EncryptionConfiguration.Builder)((S3EncryptionConfiguration.Builder)S3EncryptionConfiguration.builder().awsCredentialsProvider(credentialsProvider)).encryptionMaterialsProvider(encryptionMaterialsProvider).clientConfiguration(this.clientConfigurationFactory.getClientConfiguration("s3"))).cryptoConfiguration(this.getCryptoConfiguration()).build();
    }

    private S3EncryptionConfiguration createS3EncryptionConfigurationInitialTimeoutOnlyIfSet(AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider) {
        ClientConfiguration clientConfiguration = this.clientConfigurationFactory.getClientConfigurationInitialTimeoutOnlyIfSet("s3", null);
        if (clientConfiguration == null) {
            return null;
        }
        return (S3EncryptionConfiguration)((S3EncryptionConfiguration.Builder)((S3EncryptionConfiguration.Builder)S3EncryptionConfiguration.builder().awsCredentialsProvider(credentialsProvider)).encryptionMaterialsProvider(encryptionMaterialsProvider).clientConfiguration(clientConfiguration)).cryptoConfiguration(this.getCryptoConfiguration()).build();
    }

    private EncryptionMaterialsProvider getEncryptionMaterialsProvider() {
        return ConfigurationUtils.getEncryptionMaterialsProvider(this.configuration);
    }

    private CryptoConfiguration getCryptoConfiguration() {
        return ConfigurationUtils.getCryptoConfiguration(this.configuration);
    }

    @Override
    protected AmazonS3Lite createAmazonS3Lite(FileSystemOwner fileSystemOwner) {
        if (ConfigurationUtils.isClientSideEncryptionEnabled(this.configuration)) {
            return this.createAmazonS3EncryptionLiteClient(fileSystemOwner);
        }
        return this.createAmazonS3LiteClient(fileSystemOwner);
    }

    @Provides
    @Named(value="NonEncryptS3")
    public AmazonS3Lite createNonEncryptS3(FileSystemOwner fileSystemOwner) {
        return this.createAmazonS3LiteClient(fileSystemOwner);
    }

    private RetryPolicy getDynamoDBRetryPolicy(Configuration configuration) {
        return new RetryPolicy(new DynamoDBRetryCondition(this.createAmazonDynamoDB(null), configuration.get("fs.s3.consistent.metadata.tableName", "EmrManifest"), 10, configuration.getBoolean("fs.s3.consistent.metadata.capacity.autoIncrease", false), ConfigurationUtils.getEtagVerificationEnabled(configuration), configuration.getLong("fs.s3.consistent.metadata.capacity.autoIncrease.maxRead", -1L), configuration.getLong("fs.s3.consistent.metadata.capacity.autoIncrease.maxWrite", -1L), configuration.getDouble("fs.s3.consistent.metadata.capacity.autoIncrease.factor", 0.2)), PredefinedRetryPolicies.DYNAMODB_DEFAULT_BACKOFF_STRATEGY, Integer.MAX_VALUE, false);
    }

    private AmazonDynamoDB createAmazonDynamoDB(ClientConfiguration clientConfiguration) {
        String serviceAbbreviation = "dynamodb";
        if (clientConfiguration == null) {
            clientConfiguration = new ClientConfiguration();
        }
        AmazonDynamoDBClient amazonDynamoDB = new AmazonDynamoDBClient(this.getAwsCredentialsProvider(serviceAbbreviation), clientConfiguration);
        amazonDynamoDB.setEndpoint(EmrFsUtils.getEndpoint(serviceAbbreviation, this.configuration));
        return amazonDynamoDB;
    }

    @Override
    protected AmazonDynamoDB createAmazonDynamoDB() {
        return this.createAmazonDynamoDB(this.clientConfigurationFactory.getClientConfiguration("dynamodb", this.getDynamoDBRetryPolicy(this.configuration)));
    }

    @Override
    protected EntityStore<Entity> createEntityStore(AmazonDynamoDB dynamoDB) {
        long readCapacity = this.configuration.getLong("fs.s3.consistent.metadata.read.capacity", -1L);
        long writeCapacity = this.configuration.getLong("fs.s3.consistent.metadata.write.capacity", -1L);
        long readCapacityLimit = this.configuration.getLong("fs.s3.consistent.metadata.read.capacity.limit", readCapacity);
        long writeCapacityLimit = this.configuration.getLong("fs.s3.consistent.metadata.write.capacity.limit", writeCapacity);
        boolean prefetching = this.configuration.getBoolean("fs.s3.consistent.fastList.prefetchMetadata", false);
        boolean autoCreate = this.configuration.getBoolean("fs.s3.consistent.metadata.autoCreate", true);
        String tableName = this.configuration.get("fs.s3.consistent.metadata.tableName", "EmrFSMetadata");
        boolean conditional = this.configuration.getBoolean("fs.s3.consistent.metadata.conditional", true);
        boolean etagVerification = ConfigurationUtils.getEtagVerificationEnabled(this.configuration);
        NativeDynamoDBEntityStore nativeDynamoDBEntityStore = new NativeDynamoDBEntityStore(dynamoDB, readCapacityLimit, writeCapacityLimit).withAutoCreateTable(autoCreate).withTableName(tableName).withConditionalUpdate(conditional).withPrefetching(prefetching).withEtagVerification(etagVerification);
        if (readCapacity > 0L) {
            nativeDynamoDBEntityStore.setReadCapacityUnits(readCapacity);
        }
        if (writeCapacity > 0L) {
            nativeDynamoDBEntityStore.setWriteCapacityUnits(writeCapacity);
        }
        nativeDynamoDBEntityStore.initialize();
        return nativeDynamoDBEntityStore;
    }

    private AmazonCloudWatch createAmazonCloudWatch() {
        String serviceAbbreviation = "monitoring";
        AmazonCloudWatchClient amazonCloudWatch = new AmazonCloudWatchClient(this.getAwsCredentialsProvider(serviceAbbreviation), new ClientConfiguration());
        amazonCloudWatch.setEndpoint(EmrFsUtils.getEndpoint(serviceAbbreviation, this.configuration));
        return amazonCloudWatch;
    }

    private AmazonSQS createAmazonSQS() {
        String serviceAbbreviation = "sqs";
        AmazonSQSClient amazonSQS = new AmazonSQSClient(this.getAwsCredentialsProvider(serviceAbbreviation));
        amazonSQS.setEndpoint(EmrFsUtils.getEndpoint(serviceAbbreviation, this.configuration));
        return amazonSQS;
    }

    @Override
    protected List<Notifier> getNotifiers() {
        ArrayList<Notifier> notifiers = new ArrayList<Notifier>();
        String jobFlowId = EmrFsUtils.getJobFlowId();
        if (this.configuration.getBoolean("fs.s3.consistent.notification.CloudWatch", false)) {
            notifiers.add(new CloudWatchNotifier(this.createAmazonCloudWatch(), jobFlowId));
        }
        if (this.configuration.getBoolean("fs.s3.consistent.notification.SQS", false)) {
            String queueName = this.configuration.get("fs.s3.consistent.notification.SQS.queueName", SQSNotifier.getDefaultQueueName(jobFlowId));
            notifiers.add(new SQSNotifier(this.createAmazonSQS(), this.configuration, queueName));
        }
        return notifiers;
    }

    private List<S3CallOverrider> getS3CallOverriders(FileSystemOwner fileSystemOwner) {
        return S3CallOverridesGetter.getS3CallOverriders(this.configuration, fileSystemOwner);
    }
}

