/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.guice.BlockFastProducerPolicy;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwnerInitializationException;
import com.amazon.ws.emr.hadoop.fs.identity.HadoopFileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.notification.NotificationDispatcher;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3n.S3NativeFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3n2.S3NativeFileSystem2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.AbstractModule;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Provides;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Singleton;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.TypeLiteral;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.name.Names;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmrFSBaseModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(EmrFSBaseModule.class);
    protected URI uri;
    protected Configuration configuration;
    public static final String S3N = "s3n";
    public static final String S3N2 = "s3n2";

    public EmrFSBaseModule(URI uri, Configuration configuration) {
        this.uri = uri;
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        this.bind(EntityStore.class).to((TypeLiteral<EntityStore>)new TypeLiteral<EntityStore<Entity>>(){});
        this.bind(FileSystem.class).annotatedWith(Names.named(S3N)).to(S3NativeFileSystem.class);
        this.bind(FileSystem.class).annotatedWith(Names.named(S3N2)).to(S3NativeFileSystem2.class);
        this.bind(FileSystemOwner.class).toProvider(this::provideFileSystemOwner).asEagerSingleton();
    }

    protected abstract AWSCredentialsProvider getAwsCredentialsProvider(String var1);

    protected abstract AWSCredentialsProvider getAwsCredentialsProvider();

    protected abstract AmazonS3Lite createAmazonS3Lite(FileSystemOwner var1);

    protected abstract AmazonDynamoDB createAmazonDynamoDB();

    @Singleton
    @Provides
    protected MultipartUploadCleaner createMultipartUploadCleaner(AmazonS3Lite s3) {
        return MultipartUploadCleaner.getInstance(this.configuration, s3);
    }

    protected abstract EntityStore<Entity> createEntityStore(AmazonDynamoDB var1);

    protected abstract List<Notifier> getNotifiers();

    @Singleton
    @Provides
    AWSCredentialsProvider provideAWSCredentialsProvider() {
        return this.getAwsCredentialsProvider();
    }

    @Singleton
    @Provides
    EntityStore<Entity> provideEntityStore(AmazonDynamoDB dynamoDB) {
        return this.createEntityStore(dynamoDB);
    }

    @Singleton
    @Provides
    AmazonS3Lite provideAmazonS3Lite(FileSystemOwner fileSystemOwner) {
        return this.createAmazonS3Lite(fileSystemOwner);
    }

    @Singleton
    @Provides
    AmazonDynamoDB provideAmazonDynamoDB() {
        return this.createAmazonDynamoDB();
    }

    @Provides
    Configuration provideConfiguration() {
        return this.configuration;
    }

    @Provides
    URI provideBaseUri() {
        return this.uri;
    }

    @Provides
    ExecutorService provideExecutorService() {
        int threadPoolBufferSize;
        ThreadFactory daemonThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("s3n-worker-%d").build();
        int threadPoolSize = this.configuration.getInt("fs.s3.threadpool.size", 20);
        if (threadPoolSize <= 0 || threadPoolSize > 40) {
            threadPoolSize = 20;
            LOG.warn("Thread pool size not in (0, {}], using default {}", (Object)40, (Object)20);
        }
        if ((threadPoolBufferSize = this.configuration.getInt("fs.s3.threadpool.buffer.size", 10000)) < threadPoolSize) {
            threadPoolBufferSize = 10000;
        }
        LinkedBlockingDeque<Runnable> taskBuffer = new LinkedBlockingDeque<Runnable>(threadPoolBufferSize);
        return new ThreadPoolExecutor(threadPoolSize, 40, 60L, TimeUnit.SECONDS, taskBuffer, daemonThreadFactory, new BlockFastProducerPolicy());
    }

    @Provides
    ListeningExecutorService provideListeningExecutorService(ExecutorService executorService) {
        return MoreExecutors.listeningDecorator(executorService);
    }

    @Provides
    @Singleton
    NotificationDispatcher provideNotificationDispatcher() {
        NotificationDispatcher notificationDispatcher = new NotificationDispatcher();
        notificationDispatcher.addNotifiers(this.getNotifiers());
        return notificationDispatcher;
    }

    FileSystemOwner provideFileSystemOwner() {
        try {
            return new HadoopFileSystemOwner(UserGroupInformation.getCurrentUser());
        }
        catch (IOException ioe) {
            throw new FileSystemOwnerInitializationException(ioe);
        }
    }
}

