/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.HadoopConfigurationAWSCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.guice.AWSCredentialsProviderFactory;
import com.amazon.ws.emr.hadoop.fs.guice.UserGroupMappingAWSSessionCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAWSCredentialsProviderFactory
implements AWSCredentialsProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAWSCredentialsProviderFactory.class);

    @Override
    public AWSCredentialsProvider getAwsCredentialsProvider(String service, URI uri, Configuration configuration) {
        return this.getAwsCredentialsProviderChain(service, uri, configuration);
    }

    private AWSCredentialsProvider getAwsCredentialsProviderChain(String service, URI uri, Configuration configuration) {
        ArrayList<AWSCredentialsProvider> providers = new ArrayList<AWSCredentialsProvider>();
        AWSCredentialsProvider customProvider = this.getCustomAwsCredentialsProvider(uri, configuration);
        if (customProvider != null) {
            providers.add(customProvider);
        }
        providers.add(new UserGroupMappingAWSSessionCredentialsProvider());
        if ("dynamodb".equals(service)) {
            providers.add(new HadoopConfigurationAWSCredentialsProvider(configuration, "fs.s3.consistent.metadata.accessKey", "fs.s3.consistent.metadata.secretKey"));
        }
        providers.add(new HadoopConfigurationAWSCredentialsProvider(configuration, uri));
        providers.add(new InstanceProfileCredentialsProvider());
        return this.getChainForCredentialsProviders(providers);
    }

    @Override
    public AWSCredentialsProvider getAwsCredentialsProvidersAsChain(AWSCredentialsProvider ... providers) {
        return this.getChainForCredentialsProviders(Arrays.asList(providers));
    }

    protected AWSCredentialsProvider getChainForCredentialsProviders(List<AWSCredentialsProvider> providers) {
        AWSCredentialsProviderChain providerChain = new AWSCredentialsProviderChain(providers);
        providerChain.setReuseLastProvider(true);
        return providerChain;
    }

    private AWSCredentialsProvider getCustomAwsCredentialsProvider(URI uri, Configuration configuration) {
        String providerClass = configuration.get("fs.s3.customAWSCredentialsProvider");
        if (!Strings.isNullOrEmpty(providerClass)) {
            Class<?> clazz;
            try {
                clazz = Class.forName(providerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Custom AWSCredentialsProvider not found: " + providerClass, e);
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(URI.class, Configuration.class);
                constructor.setAccessible(true);
                return (AWSCredentialsProvider)constructor.newInstance(uri, configuration);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOG.info("Unable to create provider using constructor: {}({}, {})", new Object[]{clazz.getSimpleName(), URI.class.getName(), Configuration.class.getName()});
                return (AWSCredentialsProvider)ReflectionUtils.newInstance(clazz, (Configuration)configuration);
            }
        }
        return null;
    }
}

