/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.files;

import com.amazon.ws.emr.hadoop.fs.files.DeleteUtil;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TemporaryFiles {
    private static final FileAttribute<Set<PosixFilePermission>> FILE_PERMISSIONS = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
    public static final Logger LOG = LoggerFactory.getLogger(TemporaryFiles.class);
    private final Iterator<Path> directories;
    private final Set<Path> tracked = Sets.newConcurrentHashSet();
    private final AtomicLong namePrefixSequence = new AtomicLong(0L);

    public TemporaryFiles(TemporaryDirectories temporaryDirectories) {
        this.directories = temporaryDirectories.cyclingIterator();
    }

    private String getNextNamePrefix() {
        return String.format("%010d", this.namePrefixSequence.getAndIncrement());
    }

    public Path create() throws IOException {
        Path tempPath = this.directories.next().resolve(this.getNextNamePrefix());
        this.tracked.add(tempPath);
        try {
            Files.createFile(tempPath, FILE_PERMISSIONS);
        }
        catch (IOException | RuntimeException e) {
            this.tracked.remove(tempPath);
            throw e;
        }
        return tempPath;
    }

    public Path hardLink(Path existing) throws IOException {
        if (!this.isTracked(existing)) {
            throw new FileNotFoundException("Cannot create a hard link from an untracked path");
        }
        Path tempPath = existing.resolveSibling(this.getNextNamePrefix());
        this.tracked.add(tempPath);
        try {
            Files.createLink(tempPath, existing);
        }
        catch (NoSuchFileException e) {
            this.tracked.remove(tempPath);
            throw (FileNotFoundException)new FileNotFoundException("Cannot create a hard link from an untracked path").initCause(e);
        }
        catch (IOException | RuntimeException e) {
            this.tracked.remove(tempPath);
            throw e;
        }
        return tempPath;
    }

    public boolean delete(Path existing) {
        if (this.tracked.remove(existing)) {
            return DeleteUtil.deleteIfExistsOrLog(existing);
        }
        return false;
    }

    public boolean isTracked(Path path) {
        return this.tracked.contains(path);
    }

    public int size() {
        return this.tracked.size();
    }
}

