/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.files;

import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectoryTracker;
import java.nio.file.Path;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TemporaryDirectoryShutdownHook {
    private static final TemporaryDirectoryTracker directoryTracker = new TemporaryDirectoryTracker();

    private TemporaryDirectoryShutdownHook() {
    }

    static boolean track(Path dir) {
        return directoryTracker.track(dir);
    }

    static boolean untrack(Path dir) {
        return directoryTracker.untrack(dir);
    }

    private static void runHook() {
        directoryTracker.close();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                TemporaryDirectoryShutdownHook.runHook();
            }
        }));
    }
}

