/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.files;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeleteUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteUtil.class);

    private DeleteUtil() {
    }

    static boolean deleteIfExistsOrLog(Path tempPath) {
        try {
            Files.deleteIfExists(tempPath);
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not delete path: " + tempPath, (Throwable)e);
            }
            return false;
        }
    }

    static boolean recursiveDeleteIfExistsOrLog(Path tempPathDir) {
        CountingDeletingFileVisitor visitor = new CountingDeletingFileVisitor();
        try {
            Files.walkFileTree(tempPathDir, visitor);
            if (visitor.hasAtLeastOneFailure()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not recursively delete directory tree: " + tempPathDir);
                    visitor.logFailures();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not recursively delete directory tree: " + tempPathDir, (Throwable)e);
                visitor.logFailures();
            }
            return false;
        }
    }

    private static final class CountingDeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        private int failedFileDeletes = 0;
        private int failedDirectoryDeletes = 0;
        private int failedVisits = 0;

        private CountingDeletingFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (!DeleteUtil.deleteIfExistsOrLog(file)) {
                ++this.failedFileDeletes;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            ++this.failedVisits;
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (!DeleteUtil.deleteIfExistsOrLog(dir)) {
                ++this.failedDirectoryDeletes;
            }
            return FileVisitResult.CONTINUE;
        }

        boolean hasAtLeastOneFailure() {
            return this.failedVisits > 0 || this.failedDirectoryDeletes > 0 || this.failedFileDeletes > 0;
        }

        void logFailures() {
            if (this.hasAtLeastOneFailure()) {
                LOG.debug(String.format("%d directory deletion failures, %d file deletion failures and %d failed visits.", this.failedDirectoryDeletes, this.failedFileDeletes, this.failedVisits));
            }
        }
    }
}

