/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb.impl;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Charsets;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.RateLimiter;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.time.StopWatch;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeDynamoDBRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(NativeDynamoDBRateLimiter.class);
    private final double readPermitsPerSecond;
    private final double writePermitsPerSecond;
    private final RateLimiter readRateLimiter;
    private final RateLimiter writeRateLimiter;
    private final AtomicInteger readPermitDebt = new AtomicInteger(0);
    private final AtomicInteger writePermitDebt = new AtomicInteger(0);
    private final long readPermitTimeout;
    private final long writePermitTimeout;
    private static final int BYTES_PER_READ_CAPACITY_UNIT = 4096;
    private static final int BYTES_PER_WRITE_CAPACITY_UNIT = 1024;
    private final int THROTTLING_LOGGING_THRESHOLD = 1000;

    public NativeDynamoDBRateLimiter() {
        this(-1.0, -1.0);
    }

    public NativeDynamoDBRateLimiter(double readPermitsPerSecond, double writePermitsPerSecond) {
        this(readPermitsPerSecond, writePermitsPerSecond, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public NativeDynamoDBRateLimiter(double readPermitsPerSecond, double writePermitsPerSecond, long readPermitTimeout, long writePermitTimeout) {
        this.readPermitsPerSecond = readPermitsPerSecond;
        this.writePermitsPerSecond = writePermitsPerSecond;
        this.readPermitTimeout = readPermitTimeout;
        this.writePermitTimeout = writePermitTimeout;
        this.readRateLimiter = this.readPermitsPerSecond > 0.0 ? RateLimiter.create(readPermitsPerSecond) : null;
        this.writeRateLimiter = this.writePermitsPerSecond > 0.0 ? RateLimiter.create(writePermitsPerSecond) : null;
    }

    private void tryAcquire(RateLimiter rateLimiter, RateLimiterType type, int permits, long timeout, TimeUnit unit) {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        boolean acquired = rateLimiter.tryAcquire(permits, timeout, unit);
        stopwatch.stop();
        long elapsed = stopwatch.getTime();
        if (!acquired) {
            RuntimeException e = new RuntimeException(String.format("Timeout (%d %s) waiting for %d %s permits", new Object[]{timeout, unit, permits, type}));
            throw e;
        }
        LOG.debug("Acquired {} {} permits in {} {}", new Object[]{permits, type, elapsed, TimeUnit.MILLISECONDS});
    }

    public void beforeRead() {
        if (this.readRateLimiter != null) {
            int readPermits = this.readPermitDebt.getAndSet(-1) + 1;
            if (readPermits > 0) {
                this.tryAcquire(this.readRateLimiter, RateLimiterType.READ, readPermits, this.readPermitTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.readPermitDebt.getAndAdd(readPermits);
            }
        }
    }

    private int getConsumedCapacity(ConsumedCapacity consumedCapacity) {
        if (consumedCapacity == null) {
            return 0;
        }
        return (int)Math.ceil(consumedCapacity.getCapacityUnits());
    }

    public double getReadPermitsPerSecond() {
        return this.readPermitsPerSecond;
    }

    public double getWritePermitsPerSecond() {
        return this.writePermitsPerSecond;
    }

    public void afterRead(ConsumedCapacity consumedReadCapacity) {
        this.afterRead(this.getConsumedCapacity(consumedReadCapacity));
    }

    public void afterRead(int consumedReadPermits) {
        this.readPermitDebt.addAndGet(consumedReadPermits);
    }

    public void beforeWrite(Map<String, AttributeValue> itemToWrite) {
        if (this.writeRateLimiter != null) {
            int estimatedWriteCapacity = this.estimateWriteCapacity(itemToWrite);
            int writePermits = this.writePermitDebt.getAndSet(0 - estimatedWriteCapacity) + estimatedWriteCapacity;
            if (writePermits > 0) {
                this.tryAcquire(this.writeRateLimiter, RateLimiterType.WRITE, writePermits, this.writePermitTimeout, TimeUnit.MILLISECONDS);
            } else {
                this.writePermitDebt.getAndAdd(writePermits);
            }
        }
    }

    public void afterWrite(ConsumedCapacity consumedWriteCapacity) {
        this.afterWrite(this.getConsumedCapacity(consumedWriteCapacity));
    }

    public void afterWrite(Collection<ConsumedCapacity> consumedWriteCapacities) {
        for (ConsumedCapacity c : consumedWriteCapacities) {
            this.afterWrite(this.getConsumedCapacity(c));
        }
    }

    public void afterWrite(int consumedWritePermits) {
        this.writePermitDebt.addAndGet(consumedWritePermits);
    }

    private int estimateReadCapacity(Map<String, AttributeValue> item) {
        double itemSize = this.estimateItemSize(item);
        return new Double(Math.ceil(itemSize / 4096.0)).intValue();
    }

    private int estimateWriteCapacity(Map<String, AttributeValue> item) {
        double itemSize = this.estimateItemSize(item);
        return new Double(Math.ceil(itemSize / 1024.0)).intValue();
    }

    private double estimateItemSize(Map<String, AttributeValue> item) {
        if (item == null || item.isEmpty()) {
            return 1.0;
        }
        double bytes = 0.0;
        for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
            bytes += (double)entry.getKey().getBytes(Charsets.UTF_8).length;
            if (entry.getValue().getB() != null) {
                bytes += (double)entry.getValue().getB().remaining();
                continue;
            }
            if (entry.getValue().getS() != null) {
                bytes += (double)entry.getValue().getS().getBytes(Charsets.UTF_8).length;
                continue;
            }
            if (entry.getValue().getN() != null) {
                bytes += (double)entry.getValue().getN().getBytes(Charsets.UTF_8).length;
                continue;
            }
            if (entry.getValue().getBS() != null && !entry.getValue().getBS().isEmpty()) {
                for (ByteBuffer b : entry.getValue().getBS()) {
                    bytes += (double)b.remaining();
                }
                continue;
            }
            if (entry.getValue().getSS() != null && !entry.getValue().getSS().isEmpty()) {
                for (String s : entry.getValue().getSS()) {
                    bytes += (double)s.getBytes(Charsets.UTF_8).length;
                }
                continue;
            }
            if (entry.getValue().getNS() == null || entry.getValue().getNS().isEmpty()) continue;
            for (String n : entry.getValue().getNS()) {
                bytes += (double)n.getBytes(Charsets.UTF_8).length;
            }
        }
        return bytes;
    }

    static enum RateLimiterType {
        READ,
        WRITE;

    }
}

