/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;

public class ItemKey
implements Comparable<ItemKey> {
    private String hashKey;
    private String rangeKey;

    public ItemKey(String hashKey) {
        this(hashKey, null);
    }

    public ItemKey(String hashKey, String rangeKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hashKey), "Hash key cannot be empty");
        this.hashKey = hashKey;
        this.rangeKey = rangeKey;
    }

    public ItemKey(ItemKey itemKey) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        this.hashKey = itemKey.getHashKey();
        this.rangeKey = itemKey.getRangeKey();
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public void setHashKey(String hashKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hashKey), "Hash key cannot be empty");
        this.hashKey = hashKey;
    }

    public ItemKey withHashKey(String hashKey) {
        this.setHashKey(hashKey);
        return this;
    }

    public String getRangeKey() {
        return this.rangeKey;
    }

    public void setRangeKey(String rangeKey) {
        this.rangeKey = rangeKey;
    }

    public ItemKey withRangeKey(String rangeKey) {
        this.setRangeKey(rangeKey);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemKey itemKey = (ItemKey)o;
        if (!this.hashKey.equals(itemKey.hashKey)) {
            return false;
        }
        return !(this.rangeKey != null ? !this.rangeKey.equals(itemKey.rangeKey) : itemKey.rangeKey != null);
    }

    public int hashCode() {
        int result = this.hashKey.hashCode();
        result = 31 * result + (this.rangeKey != null ? this.rangeKey.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(ItemKey o) {
        if (o == null) {
            return 1;
        }
        int ret = this.hashKey.compareTo(o.getHashKey());
        return ret != 0 ? ret : this.compareNullableValues(this.rangeKey, o.getRangeKey());
    }

    private int compareNullableValues(String left, String right) {
        if (left != null && right != null) {
            return left.compareTo(right);
        }
        if (left != null) {
            return 1;
        }
        if (right != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "ItemKey{hashKey='" + this.hashKey + '\'' + ", rangeKey='" + this.rangeKey + '\'' + '}';
    }
}

