/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb;

import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.Arrays;

public class Entity {
    protected ItemKey itemKey;
    protected Long counter;
    protected Long lastModified;
    protected byte[] payload;
    protected Long deletionTTL;
    protected String etag;

    public Entity(ItemKey itemKey) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        this.itemKey = itemKey;
        this.payload = null;
        this.deletionTTL = 0L;
        this.etag = null;
    }

    public Entity(ItemKey itemKey, byte[] payload) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        this.itemKey = itemKey;
        this.setPayload(payload);
        this.deletionTTL = 0L;
        this.etag = null;
    }

    public Entity(Entity entity) {
        this.itemKey = new ItemKey(entity.getItemKey());
        this.setPayload(entity.getPayload());
        this.setCounter(entity.getCounter());
        this.setLastModified(entity.getLastModified());
        this.setDeletionTTL(entity.getDeletionTTL());
        this.setEtag(entity.getEtag());
    }

    public ItemKey getItemKey() {
        return this.itemKey;
    }

    public void setItemKey(ItemKey itemKey) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        this.itemKey = itemKey;
    }

    public Entity withItemKey(ItemKey itemKey) {
        this.setItemKey(itemKey);
        return this;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = (byte[])(payload != null ? Arrays.copyOf(payload, payload.length) : null);
    }

    public Entity withPayload(byte[] payload) {
        this.setPayload(payload);
        return this;
    }

    public Long getCounter() {
        return this.counter;
    }

    public void setCounter(Long counter) {
        this.counter = counter;
    }

    public Entity withCounter(Long counter) {
        this.setCounter(counter);
        return this;
    }

    public void resetCounter() {
        this.counter = null;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Entity withLastModified(Long lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public Long getDeletionTTL() {
        return this.deletionTTL;
    }

    public void setDeletionTTL(long deletionTTL) {
        this.deletionTTL = deletionTTL;
    }

    public Entity withDeletionTTL(long deletionTTL) {
        this.deletionTTL = deletionTTL;
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public Entity withEtag(String etag) {
        this.setEtag(etag);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        if (!this.itemKey.equals(entity.itemKey)) {
            return false;
        }
        return Arrays.equals(this.payload, entity.payload);
    }

    public int hashCode() {
        int result = this.itemKey.hashCode();
        result = 31 * result + (this.payload != null ? Arrays.hashCode(this.payload) : 0);
        return result;
    }

    public String toString() {
        return "Entity{itemKey=" + this.itemKey + ", counter=" + this.counter + ", lastModified=" + this.lastModified + ", deletionTTL=" + this.deletionTTL + ", payload=" + Arrays.toString(this.payload) + ", eTag=" + this.etag + "}";
    }
}

