/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.cse;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class KMSEncryptionMaterialsProvider
implements EncryptionMaterialsProvider,
Configurable {
    private Configuration conf;
    private com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider kmsEncryptionMaterialsProvider;

    private void initialize() {
        String keyId = this.conf.get("fs.s3.cse.kms.keyId");
        Preconditions.checkArgument(StringUtils.isNotBlank(keyId), String.format("%s cannot be empty", "fs.s3.cse.kms.keyId"));
        this.kmsEncryptionMaterialsProvider = new com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider(new KMSEncryptionMaterials(keyId));
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(Map<String, String> materialsDescription) {
        if (this.kmsEncryptionMaterialsProvider != null) {
            return this.kmsEncryptionMaterialsProvider.getEncryptionMaterials(materialsDescription);
        }
        throw new RuntimeException("KMSEncryptionMaterialsProvider is not initialized");
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials() {
        if (this.kmsEncryptionMaterialsProvider != null) {
            return this.kmsEncryptionMaterialsProvider.getEncryptionMaterials();
        }
        throw new RuntimeException("KMSEncryptionMaterialsProvider is not initialized");
    }

    @Override
    public void refresh() {
        if (this.kmsEncryptionMaterialsProvider != null) {
            this.kmsEncryptionMaterialsProvider.refresh();
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.initialize();
    }

    public Configuration getConf() {
        return this.conf;
    }
}

