/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.cse;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AbortMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CompleteMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.ExtraUploadMetadata;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressListener;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.UploadObjectObserver;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.internal.PartCreationEvent;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PartETag;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CSEUploadObjectObserver
extends UploadObjectObserver {
    private static final Logger logger = LoggerFactory.getLogger(CSEUploadObjectObserver.class);
    @NonNull
    private final LongSupplier totalLengthSupplier;
    @NonNull
    private final ExtraUploadMetadata extraUploadMetadata;
    @NonNull
    private final MultipartUploadDispatcher dispatcher;
    @Nullable
    private final ProgressListener progressListener;

    @Override
    protected UploadPartRequest newUploadPartRequest(PartCreationEvent event, File part) {
        UploadPartRequest request = super.newUploadPartRequest(event, part);
        if (this.progressListener != null) {
            request.setGeneralProgressListener(this.progressListener);
        }
        return request;
    }

    @Override
    public CompleteMultipartUploadResult onCompletion(List<PartETag> partETags) {
        try {
            this.completeOrAbortOnFailure(partETags);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    @Override
    public void onAbort() {
        this.cancelFutures();
        try {
            this.abortUploadIfInitiated();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void cancelFutures() {
        for (Future<UploadPartResult> future : this.getFutures()) {
            future.cancel(true);
        }
    }

    private void completeOrAbortOnFailure(List<PartETag> partETags) throws IOException {
        CompleteMultipartUploadEvent event = CompleteMultipartUploadEvent.builder().bucket(this.getRequest().getBucketName()).key(this.getRequest().getKey()).partETags(partETags).uploadId(this.getUploadId()).totalLength(this.totalLengthSupplier.getAsLong()).extraUploadMetadata(this.extraUploadMetadata).build();
        try {
            this.dispatcher.complete(event);
        }
        catch (IOException | RuntimeException e) {
            this.abortUploadOrAddSuppressedIfFails(e);
            throw e;
        }
    }

    private void abortUploadOrAddSuppressedIfFails(Exception exception) {
        try {
            this.abortUpload();
        }
        catch (IOException | RuntimeException abortException) {
            exception.addSuppressed(abortException);
        }
    }

    private void abortUploadIfInitiated() throws IOException {
        if (this.getUploadId() != null) {
            this.abortUpload();
        }
    }

    private void abortUpload() throws IOException {
        AbortMultipartUploadEvent event = this.getAbortEvent();
        try {
            this.dispatcher.abort(event);
        }
        catch (IOException | RuntimeException e) {
            logger.debug("Failed to dispatch an event to abort a multipart upload: {}", (Object)event);
            throw e;
        }
    }

    private AbortMultipartUploadEvent getAbortEvent() {
        return AbortMultipartUploadEvent.builder().bucket(this.getRequest().getBucketName()).key(this.getRequest().getKey()).uploadId(this.getUploadId()).build();
    }

    CSEUploadObjectObserver(@NonNull LongSupplier totalLengthSupplier, @NonNull ExtraUploadMetadata extraUploadMetadata, @NonNull MultipartUploadDispatcher dispatcher, @Nullable ProgressListener progressListener) {
        if (totalLengthSupplier == null) {
            throw new NullPointerException("totalLengthSupplier");
        }
        if (extraUploadMetadata == null) {
            throw new NullPointerException("extraUploadMetadata");
        }
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher");
        }
        this.totalLengthSupplier = totalLengthSupplier;
        this.extraUploadMetadata = extraUploadMetadata;
        this.dispatcher = dispatcher;
        this.progressListener = progressListener;
    }

    public static CSEUploadObjectObserverBuilder builder() {
        return new CSEUploadObjectObserverBuilder();
    }

    public static class CSEUploadObjectObserverBuilder {
        private LongSupplier totalLengthSupplier;
        private ExtraUploadMetadata extraUploadMetadata;
        private MultipartUploadDispatcher dispatcher;
        private ProgressListener progressListener;

        CSEUploadObjectObserverBuilder() {
        }

        public CSEUploadObjectObserverBuilder totalLengthSupplier(LongSupplier totalLengthSupplier) {
            this.totalLengthSupplier = totalLengthSupplier;
            return this;
        }

        public CSEUploadObjectObserverBuilder extraUploadMetadata(ExtraUploadMetadata extraUploadMetadata) {
            this.extraUploadMetadata = extraUploadMetadata;
            return this;
        }

        public CSEUploadObjectObserverBuilder dispatcher(MultipartUploadDispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public CSEUploadObjectObserverBuilder progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public CSEUploadObjectObserver build() {
            return new CSEUploadObjectObserver(this.totalLengthSupplier, this.extraUploadMetadata, this.dispatcher, this.progressListener);
        }

        public String toString() {
            return "CSEUploadObjectObserver.CSEUploadObjectObserverBuilder(totalLengthSupplier=" + this.totalLengthSupplier + ", extraUploadMetadata=" + this.extraUploadMetadata + ", dispatcher=" + this.dispatcher + ", progressListener=" + this.progressListener + ")";
        }
    }
}

