/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.consistency.exception.MalformedItemKeyException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Splitter;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

public final class ItemKeys {
    private static final String HASH_KEY_PREFIX = "/";

    public static ItemKey toItemKey(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        Preconditions.checkArgument(path.toUri().getAuthority() != null, "Path must have an authority");
        return ItemKeys.toItemKey(EmrFsUtils.pathToBucket(path), EmrFsUtils.pathToKey(path));
    }

    public static ItemKey toItemKey(@NonNull String bucket, @NonNull String key) {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        ItemKeys.checkValidBucket(bucket);
        String normalizedKey = ItemKeys.normalizeKey(key);
        if (normalizedKey.isEmpty()) {
            return ItemKeys.getRootBucketItemKey(bucket);
        }
        String fullKey = bucket + HASH_KEY_PREFIX + normalizedKey;
        int indexOfSeparator = fullKey.lastIndexOf(HASH_KEY_PREFIX);
        String hashKey = HASH_KEY_PREFIX + fullKey.substring(0, indexOfSeparator);
        String rangeKey = fullKey.substring(indexOfSeparator + 1);
        return new ItemKey(hashKey, rangeKey);
    }

    public static ItemKey toItemKeyForListingPrefix(@NonNull String bucket, @NonNull String prefix) {
        if (bucket == null) {
            throw new NullPointerException("bucket");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        ItemKey itemKey = ItemKeys.toItemKey(bucket, prefix);
        if (itemKey.getRangeKey().equals("_$folder$")) {
            return new ItemKey(itemKey.getHashKey());
        }
        return new ItemKey(itemKey.getHashKey() + HASH_KEY_PREFIX + itemKey.getRangeKey());
    }

    public static String getBucket(@NonNull ItemKey itemKey) {
        if (itemKey == null) {
            throw new NullPointerException("itemKey");
        }
        ItemKeys.checkItemKey(itemKey);
        return ItemKeys.extractBucket(itemKey);
    }

    public static String getS3Key(@NonNull ItemKey itemKey) {
        if (itemKey == null) {
            throw new NullPointerException("itemKey");
        }
        ItemKeys.checkItemKey(itemKey);
        Preconditions.checkNotNull(itemKey.getRangeKey(), "ItemKey (%s) must have range key", itemKey);
        Preconditions.checkArgument(!itemKey.getRangeKey().isEmpty(), "ItemKey (%s) must have a nonempty range key", itemKey);
        return ItemKeys.extractS3Key(itemKey);
    }

    public static String getS3KeyFromMetadata(@NonNull ItemKey itemKey, boolean isDirectory) {
        if (itemKey == null) {
            throw new NullPointerException("itemKey");
        }
        String key = ItemKeys.getS3Key(itemKey);
        boolean addFolderSuffix = isDirectory && !key.equals("_$folder$");
        return addFolderSuffix ? key + "_$folder$" : key;
    }

    public static String toPathString(@NonNull ItemKey itemKey) {
        if (itemKey == null) {
            throw new NullPointerException("itemKey");
        }
        String key = ItemKeys.getS3Key(itemKey);
        return String.format("s3://%s/%s", ItemKeys.extractBucket(itemKey), key);
    }

    private static void checkValidBucket(String bucket) {
        Preconditions.checkArgument(!bucket.isEmpty(), "Bucket must not be empty");
        Preconditions.checkArgument(!bucket.contains(HASH_KEY_PREFIX), "Bucket (%s) must not contain '%s'", bucket, HASH_KEY_PREFIX);
    }

    private static void checkItemKey(ItemKey itemKey) {
        String hashKey = itemKey.getHashKey();
        if (hashKey.length() < 2 || hashKey.charAt(0) != '/' || hashKey.charAt(1) == '/') {
            throw new MalformedItemKeyException(String.format("ItemKey (%1$s) must have a hashKey that is at least two characters long, its first character be '%2$s', and its second character not be '%2$s", itemKey, Character.valueOf('/')));
        }
    }

    private static String normalizeKey(String key) {
        return Joiner.on(HASH_KEY_PREFIX).join(Splitter.on(HASH_KEY_PREFIX).omitEmptyStrings().split(key));
    }

    private static ItemKey getRootBucketItemKey(String bucket) {
        return new ItemKey(HASH_KEY_PREFIX + bucket, "_$folder$");
    }

    private static String extractBucket(ItemKey itemKey) {
        String hashKey = itemKey.getHashKey();
        return Splitter.on('/').omitEmptyStrings().split(hashKey).iterator().next();
    }

    private static String extractS3Key(ItemKey itemKey) {
        String fullKey = itemKey.getHashKey() + HASH_KEY_PREFIX + itemKey.getRangeKey();
        int indexOfSeparator = fullKey.indexOf(HASH_KEY_PREFIX, HASH_KEY_PREFIX.length());
        return fullKey.substring(indexOfSeparator + 1);
    }

    private ItemKeys() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

