/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.EmrFsStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.protobuf.InvalidProtocolBufferException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletionTTLUtils {
    private static final int PROGRESS_MESSAGE_ROW_COUNT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(DeletionTTLUtils.class);

    private DeletionTTLUtils() {
    }

    public static boolean hasInvalidTTLField(EntityStore<Entity> entityStore) throws InvalidProtocolBufferException {
        boolean hasValidationError = false;
        int count = 0;
        for (Entity entity : entityStore.dump()) {
            String message;
            ++count;
            EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.parseFrom(entity.getPayload());
            if (metadataFile == null) {
                String message2 = "MISSING METAFILE: HashKey: " + entity.getItemKey().getHashKey() + " RangeKey:" + entity.getItemKey().getRangeKey();
                LOG.warn(message2);
                hasValidationError = true;
                continue;
            }
            Long timeStamp = entity.getDeletionTTL();
            if (metadataFile.getState() == EmrFsStore.MetadataFile.State.DELETED) {
                if (DeletionTTLUtils.isTTLEmpty(timeStamp)) {
                    message = "MISSING TTL FIELD: HashKey: " + entity.getItemKey().getHashKey() + " RangeKey:" + entity.getItemKey().getRangeKey();
                    hasValidationError = true;
                    LOG.error(message);
                }
            } else if (!DeletionTTLUtils.isTTLEmpty(timeStamp)) {
                message = "HAS UNEXPECTED TTL FIELD: HashKey: " + entity.getItemKey().getHashKey() + " RangeKey:" + entity.getItemKey().getRangeKey();
                hasValidationError = true;
                LOG.error(message);
            }
            if (count % 10000 != 0) continue;
            LOG.info("Progress: Total Items Verified: {}", (Object)count);
        }
        LOG.info("Validated {} items for proper TTL Values. Table Name: {}", (Object)count, (Object)entityStore.getTableName());
        return hasValidationError;
    }

    public static void populateTTL(EntityStore<Entity> entityStore, long timeToExpireInSeconds) throws InvalidProtocolBufferException {
        int updateCount = 0;
        int readCount = 0;
        for (Entity entity : entityStore.dump()) {
            EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.parseFrom(entity.getPayload());
            if (metadataFile == null) {
                String message = "MISSING METAFILE: HashKey: " + entity.getItemKey().getHashKey() + " RangeKey:" + entity.getItemKey().getRangeKey();
                LOG.warn(message);
                continue;
            }
            Long timeStamp = entity.getDeletionTTL();
            if (metadataFile.getState() == EmrFsStore.MetadataFile.State.DELETED && DeletionTTLUtils.isTTLEmpty(timeStamp)) {
                ++updateCount;
                entity.setDeletionTTL(DateTime.now().getMillis() / 1000L + timeToExpireInSeconds);
                entityStore.update(entity);
            }
            if (++readCount % 10000 != 0) continue;
            LOG.info("Progress: Total Items Read: {}, Total Updated items: {}", (Object)readCount, (Object)updateCount);
        }
        LOG.info("Completed: Read {} entries and populated {} entries with TTL Values. Table Name: {}", new Object[]{readCount, updateCount, entityStore.getTableName()});
    }

    public static boolean isTTLEmpty(Long timeStamp) {
        return timeStamp == null || timeStamp == 0L;
    }
}

