/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.AbstractIterator;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.Pair;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.Triple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CombinedS3DynamoListing
implements Iterable<Triple<S3ObjectSummary, String, Entity>> {
    private final Iterable<Pair<S3ObjectSummary, String>> s3ObjectListing;
    private final Iterable<Entity> entityIterable;

    public CombinedS3DynamoListing(Iterable<Pair<S3ObjectSummary, String>> s3ObjectListing, Iterable<Entity> entityIterable) {
        this.s3ObjectListing = s3ObjectListing;
        this.entityIterable = entityIterable;
    }

    @Override
    public Iterator<Triple<S3ObjectSummary, String, Entity>> iterator() {
        return new CombinedS3DynamoIterator(this.s3ObjectListing.iterator(), this.entityIterable.iterator());
    }

    private static class CombinedS3DynamoIterator
    extends AbstractIterator<Triple<S3ObjectSummary, String, Entity>> {
        private Iterator<Pair<S3ObjectSummary, String>> s3ObjectIterator;
        private Iterator<Entity> entityIterator;
        private Pair<S3ObjectSummary, String> curS3Value = null;
        private Entity curEntityValue = null;
        private final Set<String> usedFolderNames = new HashSet<String>();

        CombinedS3DynamoIterator(Iterator<Pair<S3ObjectSummary, String>> s3ObjectIterator, Iterator<Entity> entityIterator) {
            this.s3ObjectIterator = s3ObjectIterator;
            this.entityIterator = entityIterator;
        }

        private boolean shouldSkipS3() {
            if (this.curS3Value == null) {
                return false;
            }
            if (this.curS3Value.getLeft() != null && this.curS3Value.getLeft().getKey().endsWith("/")) {
                return true;
            }
            String s3Prefix = this.extractS3Prefix();
            return this.usedFolderNames.contains(s3Prefix);
        }

        private String extractS3Prefix() {
            String s3Prefix;
            String string = s3Prefix = this.curS3Value.getLeft() == null ? this.curS3Value.getRight() : this.curS3Value.getLeft().getKey();
            if (s3Prefix.endsWith("_$folder$")) {
                s3Prefix = s3Prefix.substring(0, s3Prefix.length() - "_$folder$".length()) + "/";
            }
            return s3Prefix;
        }

        private boolean s3ValueRepresentsFolder() {
            if (this.curS3Value.getLeft() == null) {
                return this.curS3Value.getRight() != null;
            }
            return this.curS3Value.getLeft().getKey().endsWith("_$folder$");
        }

        @Override
        protected Triple<S3ObjectSummary, String, Entity> computeNext() {
            Triple<Object, Object, Entity> triple;
            if (this.curS3Value == null && this.s3ObjectIterator.hasNext()) {
                this.curS3Value = this.s3ObjectIterator.next();
                while (this.shouldSkipS3()) {
                    this.curS3Value = null;
                    if (!this.s3ObjectIterator.hasNext()) continue;
                    this.curS3Value = this.s3ObjectIterator.next();
                }
            }
            if (this.curEntityValue == null && this.entityIterator.hasNext()) {
                this.curEntityValue = this.entityIterator.next();
            }
            if (this.curS3Value == null && this.curEntityValue == null) {
                return (Triple)this.endOfData();
            }
            if (this.curS3Value == null) {
                triple = Triple.of(null, null, this.curEntityValue);
                this.curEntityValue = null;
            } else if (this.curEntityValue == null) {
                String s3Prefix = this.extractS3Prefix();
                if (this.s3ValueRepresentsFolder()) {
                    this.usedFolderNames.add(s3Prefix);
                }
                triple = Triple.of(this.curS3Value.getLeft(), this.curS3Value.getRight(), null);
                this.curS3Value = null;
            } else {
                String entityPrefix;
                String entityPrefixWithoutBucket;
                int cmp;
                String s3Prefix = this.extractS3Prefix();
                if (this.s3ValueRepresentsFolder()) {
                    this.usedFolderNames.add(s3Prefix);
                }
                if ((cmp = (entityPrefixWithoutBucket = (entityPrefix = this.curEntityValue.getItemKey().getHashKey() + "/" + this.curEntityValue.getItemKey().getRangeKey()).substring(entityPrefix.indexOf("/", 1) + 1)).compareTo(s3Prefix)) < 0) {
                    triple = Triple.of(null, null, this.curEntityValue);
                    this.curEntityValue = null;
                } else if (cmp == 0) {
                    triple = Triple.of(this.curS3Value.getLeft(), this.curS3Value.getRight(), this.curEntityValue);
                    this.curS3Value = null;
                    this.curEntityValue = null;
                } else {
                    triple = Triple.of(this.curS3Value.getLeft(), this.curS3Value.getRight(), null);
                    this.curS3Value = null;
                }
            }
            return triple;
        }
    }
}

