/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.concurrent;

import com.amazon.ws.emr.hadoop.fs.concurrent.Consumer;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Optional;
import java.util.concurrent.BlockingQueue;

public class BlockingQueueConsumer<T>
implements Runnable {
    private BlockingQueue<Optional<T>> queue;
    private Consumer<T> consumer;
    private volatile boolean keepRunning = true;

    public BlockingQueueConsumer(BlockingQueue<Optional<T>> queue, Consumer<T> consumer) {
        this.queue = queue;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        this.consumer.beforeConsumption();
        while (this.keepRunning) {
            Optional<T> value;
            try {
                value = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (value.isPresent()) {
                this.consumer.consume(value.get());
                continue;
            }
            this.keepRunning = false;
        }
        this.consumer.afterConsumption();
    }

    public void stop() {
        this.keepRunning = false;
    }
}

