/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.client;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonElement;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonObject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParseException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.JsonParser;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.HttpEntity;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.HttpResponse;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.ResponseHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpGet;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.client.methods.HttpUriRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.impl.client.CloseableHttpClient;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.impl.client.HttpClients;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(YarnClient.class);
    private final Configuration configuration;
    private final String resourceManagerEndpoint;
    private final CloseableHttpClient httpClient;

    public YarnClient(Configuration conf) {
        this.configuration = conf;
        this.resourceManagerEndpoint = "http://" + this.configuration.get("yarn.resourcemanager.webapp.address");
        this.httpClient = HttpClients.createDefault();
    }

    @VisibleForTesting
    public YarnClient(Configuration conf, CloseableHttpClient httpClient) {
        this.configuration = conf;
        this.resourceManagerEndpoint = "http://" + this.configuration.get("yarn.resourcemanager.webapp.address");
        this.httpClient = httpClient;
    }

    private String makeRestApiRequest(final String url) {
        try {
            HttpGet request = new HttpGet(url);
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                @Override
                public String handleResponse(HttpResponse response) throws IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        LOG.warn("Received failed response for {} (HTTP error code {})", (Object)url, (Object)status);
                        return "";
                    }
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString(entity) : "";
                }
            };
            return this.httpClient.execute((HttpUriRequest)request, responseHandler);
        }
        catch (IOException e) {
            LOG.warn("The GET request failed for the URL {} ", (Object)url, (Object)e);
            return "";
        }
    }

    private JsonObject parseJsonResponse(String response) {
        if (!StringUtils.isEmpty(response)) {
            try {
                JsonParser parser = new JsonParser();
                return parser.parse(response).getAsJsonObject();
            }
            catch (JsonParseException | IllegalStateException e) {
                LOG.warn("Unable to parse the response {} to JSON", (Object)response, (Object)e);
            }
        }
        return null;
    }

    public String getApplicationTypeById(String applicationId) {
        String response;
        String applicationType = "OTHER";
        if (!Strings.isNullOrEmpty(applicationId) && !(response = this.makeRestApiRequest(this.resourceManagerEndpoint + "/ws/v1/cluster/apps/" + applicationId)).isEmpty()) {
            JsonObject app;
            JsonElement appElement;
            JsonObject jsonObject = this.parseJsonResponse(response);
            if (jsonObject != null && jsonObject.has("app") && (appElement = jsonObject.get("app")).isJsonObject() && (app = appElement.getAsJsonObject()).has("applicationType")) {
                applicationType = app.get("applicationType").getAsString();
            }
            if (applicationType.equals("OTHER")) {
                LOG.warn("The parsed JSON does not contain ApplicationType.");
                LOG.warn(response);
            }
        }
        return applicationType;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

