/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.annotation;

import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessorImpl;
import com.amazon.ws.emr.hadoop.fs.annotation.application.ApplicationTypeConfigurationProcessor;
import com.amazon.ws.emr.hadoop.fs.annotation.application.DefaultConfigurationProcessor;
import com.amazon.ws.emr.hadoop.fs.annotation.application.SparkConfigurationProcessor;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Enums;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Objects;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Optional;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.text.StrLookup;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemVariableLookup
extends StrLookup<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SystemVariableLookup.class);
    private final Configuration configuration;
    private final ApplicationTypeConfigurationProcessor applicationTypeConfigurationProcessor;

    public SystemVariableLookup(Configuration configuration) {
        this.configuration = configuration;
        Optional<AnnotationProcessorImpl.ApplicationType> applicationTypeOptional = Enums.getIfPresent(AnnotationProcessorImpl.ApplicationType.class, configuration.get("yarn.application.type").toUpperCase());
        this.applicationTypeConfigurationProcessor = applicationTypeOptional.isPresent() ? this.getApplicationTypeConfigurationProcessor(applicationTypeOptional.get()) : null;
    }

    @Override
    public String lookup(String key) {
        SystemVariable systemVariable = SystemVariable.of(key);
        switch (systemVariable.getSource()) {
            case CONFIGURATION: {
                return this.applicationTypeConfigurationProcessor != null ? this.lookupConfiguration(systemVariable, this.applicationTypeConfigurationProcessor) : "";
            }
            case SYSTEM_ENV: {
                return Objects.firstNonNull(System.getenv(systemVariable.getSourceKey()), "");
            }
            case JOB_FLOW_INFO: {
                return EmrFsUtils.getJobFlowId();
            }
        }
        LOG.warn("System variable source {} is not supported", (Object)systemVariable.getSource());
        throw new UnsupportedOperationException(String.format("System variable source %s is not supported.", new Object[]{systemVariable.getSource()}));
    }

    private String lookupConfiguration(SystemVariable key, ApplicationTypeConfigurationProcessor configurationProcessor) {
        switch (key) {
            case MAPREDUCE_JOB_ID: {
                return configurationProcessor.getJobId();
            }
            case MAPREDUCE_JOB_NAME: {
                return configurationProcessor.getJobName();
            }
            case MAPREDUCE_JOB_APP_ATTEMPT_ID: {
                return configurationProcessor.getApplicationAttemptId();
            }
            case MAPREDUCE_TASK_ID: {
                return configurationProcessor.getTaskId();
            }
            case MAPREDUCE_TASK_ATTEMPT_ID: {
                return configurationProcessor.getTaskAttemptId();
            }
        }
        return "";
    }

    private ApplicationTypeConfigurationProcessor getApplicationTypeConfigurationProcessor(AnnotationProcessorImpl.ApplicationType applicationType) {
        switch (applicationType) {
            case MAPREDUCE: {
                return new DefaultConfigurationProcessor(this.configuration);
            }
            case SPARK: {
                return new SparkConfigurationProcessor();
            }
        }
        return new DefaultConfigurationProcessor(this.configuration);
    }

    static enum SystemVariable {
        EMR_CLUSTER_ID("emr:cluster_id", Source.JOB_FLOW_INFO),
        MAPREDUCE_JOB_ID("mapreduce:job_id", Source.CONFIGURATION),
        MAPREDUCE_JOB_NAME("mapreduce:job_name", Source.CONFIGURATION),
        MAPREDUCE_JOB_APP_ATTEMPT_ID("mapreduce:job_app_attempt_id", Source.CONFIGURATION),
        MAPREDUCE_TASK_ID("mapreduce:task_id", Source.CONFIGURATION),
        MAPREDUCE_TASK_ATTEMPT_ID("mapreduce:task_attempt_id", Source.CONFIGURATION),
        YARN_CONTAINER_ID("yarn:container_id", Source.SYSTEM_ENV, "CONTAINER_ID"),
        YARN_USER("yarn:user", Source.SYSTEM_ENV, "USER");

        private final String name;
        private final Source source;
        private final String sourceKey;

        private SystemVariable(String name, Source source) {
            this(name, source, null);
        }

        private SystemVariable(String name, Source source, String sourceKey) {
            this.name = name;
            this.source = source;
            this.sourceKey = sourceKey;
        }

        public String getName() {
            return this.name;
        }

        public Source getSource() {
            return this.source;
        }

        public String getSourceKey() {
            return this.sourceKey;
        }

        public static SystemVariable of(String name) {
            Preconditions.checkNotNull(name);
            for (SystemVariable systemVariable : SystemVariable.values()) {
                if (!StringUtils.equals(systemVariable.getName(), name)) continue;
                return systemVariable;
            }
            throw new IllegalArgumentException(String.format("%s is not a valid SystemVariable", name));
        }
    }

    static enum Source {
        CONFIGURATION,
        JOB_FLOW_INFO,
        SYSTEM_ENV;

    }
}

