/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs;

import com.amazon.ws.emr.hadoop.fs.s3n.S3Credentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.BasicAWSCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.BasicSessionCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfigurationAWSCredentialsProvider
implements AWSCredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(HadoopConfigurationAWSCredentialsProvider.class);
    public static final String AWS_ACCESS_KEY_ID_PROPERTY = "fs.%s.awsAccessKeyId";
    public static final String AWS_SECRET_ACCESS_KEY_PROPERTY = "fs.%s.awsSecretAccessKey";
    public static final String AWS_SESSION_TOKEN_PROPERTY = "fs.%s.awsSessionToken";
    private AWSCredentials awsCredentials;

    public HadoopConfigurationAWSCredentialsProvider(Configuration configuration, String scheme) {
        this(configuration, String.format(AWS_ACCESS_KEY_ID_PROPERTY, scheme), String.format(AWS_SECRET_ACCESS_KEY_PROPERTY, scheme), String.format(AWS_SESSION_TOKEN_PROPERTY, scheme));
    }

    public HadoopConfigurationAWSCredentialsProvider(Configuration configuration, URI uri) {
        try {
            S3Credentials s3Credentials = new S3Credentials();
            s3Credentials.initialize(uri, configuration);
            this.awsCredentials = HadoopConfigurationAWSCredentialsProvider.createCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey(), s3Credentials.getSessionToken());
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Couldn't extract aws credentials from either uri {} or hadoop configuration.", (Object)uri);
        }
    }

    public HadoopConfigurationAWSCredentialsProvider(Configuration configuration, String accessKeyProperty, String secretKeyProperty) {
        this(configuration, accessKeyProperty, secretKeyProperty, null);
    }

    public HadoopConfigurationAWSCredentialsProvider(Configuration configuration, String accessKeyProperty, String secretKeyProperty, String sessionTokenProperty) {
        String sessionToken;
        String accessKey = configuration.get(accessKeyProperty, null);
        String secretKey = configuration.get(secretKeyProperty, null);
        String string = sessionToken = sessionTokenProperty == null ? null : configuration.get(sessionTokenProperty, null);
        if (Strings.isNullOrEmpty(accessKey) && Strings.isNullOrEmpty(secretKey)) {
            logger.debug("AWS access key and secret key should be specified in the Hadoop configuration using the keys {} and {}.", (Object)accessKeyProperty, (Object)secretKeyProperty);
        } else if (Strings.isNullOrEmpty(accessKey)) {
            logger.debug("AWS access key should be specified in the Hadoop configuration using the key {} ", (Object)accessKeyProperty);
        } else if (Strings.isNullOrEmpty(secretKey)) {
            logger.debug("AWS secret key should be specified in the Hadoop configuration using the key {} ", (Object)secretKeyProperty);
        } else {
            this.awsCredentials = HadoopConfigurationAWSCredentialsProvider.createCredentials(accessKey, secretKey, sessionToken);
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.awsCredentials;
    }

    @Override
    public void refresh() {
    }

    private static AWSCredentials createCredentials(String accessKey, String secretKey, String sessionToken) {
        return sessionToken == null ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
    }
}

