/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs;

import com.amazon.ws.emr.hadoop.fs.guice.EmrFSProdModule;
import com.amazon.ws.emr.hadoop.fs.s3n.S3NativeFileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Guice;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Injector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Key;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.name.Names;
import com.amazon.ws.emr.hadoop.fs.staging.StagingDirectoryServices;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataInputStreamBuilder;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryCapable;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EmrFileSystem
extends FileSystem
implements StagingDirectoryCapable {
    private static final Logger LOG = LoggerFactory.getLogger(EmrFileSystem.class);
    private FileSystem fileSystem = null;
    private boolean initialized = false;
    private boolean useConsistency = false;
    @Inject
    private Injector injector;

    public EmrFileSystem() {
    }

    public EmrFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
        if (this.initialized) {
            return;
        }
        Configuration conf = this.initializeConfiguration(uri, configuration);
        if (this.fileSystem == null) {
            if (this.injector == null) {
                this.injector = Guice.createInjector(new EmrFSProdModule(uri, conf));
            }
            this.useConsistency = conf.getBoolean("fs.s3.consistent", false);
            FileSystem fs = this.useConsistency ? this.injector.getInstance(Key.get(FileSystem.class, (Annotation)Names.named("s3n2"))) : this.injector.getInstance(Key.get(FileSystem.class, (Annotation)Names.named("s3n")));
            LOG.debug("Consistency {}, using {} as filesystem implementation", (Object)(this.useConsistency ? "enabled" : "disabled"), (Object)fs.getClass().getCanonicalName());
            fs.setConf(conf);
            fs.initialize(uri, conf);
            this.fileSystem = fs;
        }
        super.initialize(uri, conf);
        this.initialized = true;
    }

    @VisibleForTesting
    Configuration initializeConfiguration(URI uri, Configuration configuration) {
        if (!ConfigurationUtils.isLoadConfigurationEnabled(configuration)) {
            return configuration;
        }
        LOG.debug("Loading {} into configuration", (Object)"emrfs-site.xml");
        Configuration.addDefaultResource((String)"emrfs-site.xml");
        Configuration newConf = new Configuration();
        newConf.setAllowNullValueProperties(true);
        newConf.addResource(configuration);
        String bucketName = uri.getAuthority();
        Map bucketConfigMap = newConf.getValByRegex("^fs\\.s3\\.bucket\\." + bucketName + "\\..+");
        if (!bucketConfigMap.isEmpty()) {
            for (Map.Entry entry : bucketConfigMap.entrySet()) {
                String newKey = ((String)entry.getKey()).replaceFirst("^fs\\.s3\\.bucket\\." + bucketName + "\\.", "fs.s3.");
                if (newConf.onlyKeyExists((String)entry.getKey())) {
                    LOG.debug("Unset configuration {} for bucket {} due to {}.", new Object[]{newKey, bucketName, entry.getKey()});
                    newConf.unset(newKey);
                    continue;
                }
                LOG.debug("Override configuration {} for bucket {} due to {}.", new Object[]{newKey, bucketName, entry.getKey()});
                newConf.set(newKey, (String)entry.getValue());
            }
        }
        return newConf;
    }

    public String toString() {
        return this.fileSystem.toString();
    }

    public void setConf(Configuration conf) {
        if (this.fileSystem != null) {
            this.fileSystem.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.fileSystem.getConf();
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fileSystem.getFileBlockLocations(file, start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        return this.fileSystem.getFileBlockLocations(p, start, len);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fileSystem.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path p) throws IOException {
        return this.fileSystem.getServerDefaults(p);
    }

    public Path resolvePath(Path p) throws IOException {
        return this.fileSystem.resolvePath(p);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fileSystem.open(f, bufferSize);
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.fileSystem.open(f);
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.fileSystem.create(f);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.fileSystem.create(f, overwrite);
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.fileSystem.create(f, progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.fileSystem.create(f, replication);
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.fileSystem.create(f, replication, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.fileSystem.create(f, overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.fileSystem.create(f, overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.fileSystem.create(f, overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.create(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.create(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.fileSystem.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.createNonRecursive(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fileSystem.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean createNewFile(Path f) throws IOException {
        return this.fileSystem.createNewFile(f);
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.fileSystem.append(f);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.fileSystem.append(f, bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.fileSystem.append(f, bufferSize, progress);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.fileSystem.concat(trg, psrcs);
    }

    public short getReplication(Path src) throws IOException {
        return this.fileSystem.getReplication(src);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fileSystem.setReplication(src, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fileSystem.rename(src, dst);
    }

    public boolean delete(Path f) throws IOException {
        return this.fileSystem.delete(f);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fileSystem.delete(f, recursive);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.fileSystem.deleteOnExit(f);
    }

    public boolean cancelDeleteOnExit(Path f) {
        return this.fileSystem.cancelDeleteOnExit(f);
    }

    public boolean exists(Path f) throws IOException {
        return this.fileSystem.exists(f);
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.fileSystem.isDirectory(f);
    }

    public boolean isFile(Path f) throws IOException {
        return this.fileSystem.isFile(f);
    }

    public long getLength(Path f) throws IOException {
        return this.fileSystem.getLength(f);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.fileSystem.getContentSummary(f);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.fileSystem.listStatus(f);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.fileSystem.listCorruptFileBlocks(path);
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        return this.fileSystem.listStatus(f, filter);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        return this.fileSystem.listStatus(files);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        return this.fileSystem.listStatus(files, filter);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.fileSystem.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return this.fileSystem.globStatus(pathPattern, filter);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.fileSystem.listLocatedStatus(f);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws FileNotFoundException, IOException {
        return this.fileSystem.listFiles(f, recursive);
    }

    public Path getHomeDirectory() {
        return this.fileSystem.getHomeDirectory();
    }

    public void setWorkingDirectory(Path new_dir) {
        this.fileSystem.setWorkingDirectory(new_dir);
    }

    public Path getWorkingDirectory() {
        return this.fileSystem.getWorkingDirectory();
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fileSystem.mkdirs(f);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fileSystem.mkdirs(f, permission);
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(src, dst);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.fileSystem.moveFromLocalFile(srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.moveFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.copyToLocalFile(src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.fileSystem.moveToLocalFile(src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fileSystem.copyToLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        this.fileSystem.copyToLocalFile(delSrc, src, dst, useRawLocalFileSystem);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fileSystem.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fileSystem.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        try {
            if (this.fileSystem != null) {
                this.fileSystem.close();
                this.fileSystem = null;
            }
        }
        finally {
            super.close();
        }
    }

    public long getUsed() throws IOException {
        return this.fileSystem.getUsed();
    }

    public long getBlockSize(Path f) throws IOException {
        return this.fileSystem.getBlockSize(f);
    }

    public long getDefaultBlockSize() {
        return this.fileSystem.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path f) {
        return this.fileSystem.getDefaultBlockSize(f);
    }

    public short getDefaultReplication() {
        return this.fileSystem.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        return this.fileSystem.getDefaultReplication(path);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fileSystem.getFileStatus(f);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fileSystem.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fileSystem.getFileLinkStatus(f);
    }

    public boolean supportsSymlinks() {
        return this.fileSystem.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.fileSystem.getLinkTarget(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fileSystem.getFileChecksum(f);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fileSystem.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.fileSystem.setWriteChecksum(writeChecksum);
    }

    public FsStatus getStatus() throws IOException {
        return this.fileSystem.getStatus();
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.fileSystem.getStatus(p);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fileSystem.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fileSystem.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fileSystem.setTimes(p, mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.fileSystem.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.fileSystem.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.fileSystem.deleteSnapshot(path, snapshotName);
    }

    public String getScheme() {
        if (this.fileSystem.getUri() != null) {
            return this.fileSystem.getUri().getScheme();
        }
        return EmrFsUtils.getDefaultScheme();
    }

    public URI getUri() {
        return this.fileSystem.getUri();
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public String getName() {
        return this.fileSystem.getName();
    }

    public Path makeQualified(Path path) {
        return this.fileSystem.makeQualified(path);
    }

    public FileSystem[] getChildFileSystems() {
        return this.fileSystem.getChildFileSystems();
    }

    public void enableCache() {
        S3NativeFileSystem.enableCache();
    }

    public void disableCache() {
        S3NativeFileSystem.disableCache();
    }

    public Path[] getEmptySubDirPaths(Path parent) throws IOException {
        if (this.useConsistency) {
            throw new UnsupportedOperationException("getEmptySubDirPaths not supported when consistency is enabled");
        }
        return ((S3NativeFileSystem)this.fileSystem).getEmptySubDirPaths(parent);
    }

    public FSDataInputStreamBuilder openFile(Path path) {
        return this.fileSystem.openFile(path);
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return StagingDirectoryServices.getService(this.fileSystem);
    }
}

