/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.cli;

import com.amazon.ws.emr.hadoop.fs.HadoopConfigurationAWSCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.cli.hadoop.HadoopConfigurations;
import com.amazon.ws.emr.hadoop.fs.guice.UserGroupMappingAWSSessionCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.BasicAWSCredentials;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Optional;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.List;

public final class CredentialProviders {
    private CredentialProviders() {
    }

    public static AWSCredentialsProvider newDefault() {
        return CredentialProviders.newProviderChain(CredentialProviders.newDefaultProviders());
    }

    public static AWSCredentialsProvider forAccessAndSecretKeys(String accessKey, String secretKey) {
        List<AWSCredentialsProvider> providers = CredentialProviders.newDefaultProviders();
        providers.add(0, CredentialProviders.newBasicCredentialsProvider(accessKey, secretKey));
        return CredentialProviders.newProviderChain(providers);
    }

    public static AWSCredentialsProvider forAccessAndSecretKeys(Optional<String> accessKey, Optional<String> secretKey) {
        if (accessKey.isPresent() && secretKey.isPresent()) {
            return CredentialProviders.forAccessAndSecretKeys((String)accessKey.get(), (String)secretKey.get());
        }
        return CredentialProviders.newDefault();
    }

    private static AWSCredentialsProvider newProviderChain(List<AWSCredentialsProvider> providers) {
        AWSCredentialsProviderChain providerChain = new AWSCredentialsProviderChain(providers.toArray(new AWSCredentialsProvider[providers.size()]));
        providerChain.setReuseLastProvider(true);
        return providerChain;
    }

    private static AWSCredentialsProvider newBasicCredentialsProvider(final String accessKey, final String secretKey) {
        return new AWSCredentialsProvider(){
            private final AWSCredentials basicCredentials;
            {
                this.basicCredentials = new BasicAWSCredentials(accessKey, secretKey);
            }

            public AWSCredentials getCredentials() {
                return this.basicCredentials;
            }

            public void refresh() {
            }
        };
    }

    private static List<AWSCredentialsProvider> newDefaultProviders() {
        return Lists.newArrayList((Object[])new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new UserGroupMappingAWSSessionCredentialsProvider(), new HadoopConfigurationAWSCredentialsProvider(HadoopConfigurations.newDefault(), "s3"), InstanceProfileCredentialsProvider.getInstance()});
    }
}

