/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.ConfigurationTypeUtil;
import net.spy.memcached.ops.ConfigurationType;
import net.spy.memcached.ops.GetConfigOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseGetConfigOperationImpl
extends OperationImpl {
    private static final OperationStatus END = new OperationStatus(true, "END");
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND");
    private static final OperationStatus LOCK_ERROR = new OperationStatus(false, "LOCK_ERROR");
    private static final byte[] RN_BYTES = "\r\n".getBytes();
    private final String cmd;
    protected final Collection<ConfigurationType> types;
    private String currentType = null;
    private final int exp;
    private final boolean hasExp;
    private int currentFlags = 0;
    private byte[] data = null;
    private int readOffset = 0;
    private boolean hasValue;
    private BufferState lookingFor = BufferState.READ_CONFIG;

    public BaseGetConfigOperationImpl(String cmd, OperationCallback cb, Collection<ConfigurationType> types) {
        super(cb);
        this.cmd = cmd;
        this.types = types;
        this.exp = 0;
        this.hasExp = false;
        this.hasValue = false;
    }

    public BaseGetConfigOperationImpl(String cmd, int e, OperationCallback cb, ConfigurationType type) {
        super(cb);
        this.cmd = cmd;
        this.types = Collections.singleton(type);
        this.exp = e;
        this.hasExp = true;
        this.hasValue = false;
    }

    public final Collection<ConfigurationType> getTypes() {
        return Collections.unmodifiableCollection(this.types);
    }

    @Override
    public final void handleLine(String line) {
        if (line.equals("END")) {
            this.getLogger().debug("Get complete!");
            if (this.hasValue) {
                this.getCallback().receivedStatus(END);
            } else {
                this.getCallback().receivedStatus(NOT_FOUND);
            }
            this.transitionState(OperationState.COMPLETE);
            this.data = null;
        } else if (line.startsWith("CONFIG ")) {
            this.getLogger().debug("Got line %s", line);
            String[] configPreamble = line.split(" ");
            assert (configPreamble[0].equals("CONFIG"));
            this.currentType = configPreamble[1];
            this.currentFlags = Integer.parseInt(configPreamble[2]);
            this.data = new byte[Integer.parseInt(configPreamble[3])];
            this.readOffset = 0;
            this.hasValue = true;
            this.getLogger().debug("Set read type to data");
            this.setReadType(OperationReadType.DATA);
        } else assert (false) : "Unknown line type: " + line;
    }

    @Override
    public final void handleRead(ByteBuffer readBuffer) {
        assert (this.currentType != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        if (this.lookingFor == BufferState.READ_CONFIG) {
            this.transferFromBuffer(readBuffer);
        }
        if (this.readOffset == this.data.length && this.lookingFor == BufferState.READ_CONFIG) {
            this.updateCallBackWithResponse();
            this.lookingFor = BufferState.RESPONSE_END_START;
        }
        if (this.lookingFor != BufferState.READ_CONFIG && readBuffer.hasRemaining()) {
            this.readResponseEnding(readBuffer);
            if (this.lookingFor == BufferState.READ_COMPLETED) {
                this.resetAndChangeReadTypeToLine();
            }
        }
    }

    void transferFromBuffer(ByteBuffer readBuffer) {
        int toRead = this.data.length - this.readOffset;
        int available = readBuffer.remaining();
        toRead = Math.min(toRead, available);
        this.getLogger().debug("Reading %d bytes", toRead);
        readBuffer.get(this.data, this.readOffset, toRead);
        this.readOffset += toRead;
    }

    void updateCallBackWithResponse() {
        OperationCallback cb = this.getCallback();
        if (!(cb instanceof GetConfigOperation.Callback)) {
            throw new ClassCastException("Couldn't convert " + cb + "to a relevent op");
        }
        GetConfigOperation.Callback gcb = (GetConfigOperation.Callback)cb;
        gcb.gotData(ConfigurationType.valueOf(this.currentType.toUpperCase()), this.currentFlags, this.data);
    }

    void readResponseEnding(ByteBuffer readBuffer) {
        do {
            byte tmp = readBuffer.get();
            assert (tmp == this.lookingFor.getValue()) : "Expecting " + this.lookingFor.getValue() + ", got " + (char)tmp;
            switch (this.lookingFor) {
                case RESPONSE_END_START: {
                    this.lookingFor = BufferState.RESPONSE_END_FINISH;
                    break;
                }
                case RESPONSE_END_FINISH: {
                    this.lookingFor = BufferState.READ_COMPLETED;
                    break;
                }
                default: {
                    assert (false) : "Looking for unexpected char: " + (char)this.lookingFor.getValue();
                    {
                        break;
                    }
                }
            }
        } while (this.lookingFor != BufferState.READ_COMPLETED && readBuffer.hasRemaining());
    }

    void resetAndChangeReadTypeToLine() {
        this.currentType = null;
        this.data = null;
        this.lookingFor = BufferState.READ_CONFIG;
        this.readOffset = 0;
        this.currentFlags = 0;
        this.getLogger().debug("Setting read type back to line.");
        this.setReadType(OperationReadType.LINE);
    }

    @Override
    public final void initialize() {
        int size = 12;
        Collection<byte[]> typeBytes = ConfigurationTypeUtil.getTypeBytes(this.types);
        for (byte[] t : typeBytes) {
            size += t.length;
            ++size;
        }
        byte[] e = String.valueOf(this.exp).getBytes();
        if (this.hasExp) {
            size += e.length + 1;
        }
        ByteBuffer b = ByteBuffer.allocate(size);
        b.put(this.cmd.getBytes());
        for (byte[] t : typeBytes) {
            b.put((byte)32);
            b.put(t);
        }
        if (this.hasExp) {
            b.put((byte)32);
            b.put(e);
        }
        b.put(RN_BYTES);
        b.flip();
        this.setBuffer(b);
    }

    @Override
    protected final void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    public String toString() {
        StringBuffer typeValues = new StringBuffer();
        for (ConfigurationType type : this.types) {
            typeValues.append(" " + type.getValue());
        }
        return "Cmd: " + this.cmd + " Types: " + typeValues.toString() + "Exp: " + this.exp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BufferState {
        READ_CONFIG('*'),
        RESPONSE_END_START('\r'),
        RESPONSE_END_FINISH('\n'),
        READ_COMPLETED('\u0000');

        private byte value;

        private BufferState(char value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

