/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    @Override
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        if (createVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVolumeRequest> request = new DefaultRequest<CreateVolumeRequest>(createVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2013-10-15");
        if (createVolumeRequest.getSize() != null) {
            request.addParameter("Size", StringUtils.fromInteger(createVolumeRequest.getSize()));
        }
        if (createVolumeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(createVolumeRequest.getSnapshotId()));
        }
        if (createVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createVolumeRequest.getAvailabilityZone()));
        }
        if (createVolumeRequest.getVolumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString(createVolumeRequest.getVolumeType()));
        }
        if (createVolumeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(createVolumeRequest.getIops()));
        }
        return request;
    }
}

