/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.AvailabilityZoneDetail;
import com.amazonaws.services.xray.model.ErrorRootCause;
import com.amazonaws.services.xray.model.FaultRootCause;
import com.amazonaws.services.xray.model.Http;
import com.amazonaws.services.xray.model.InstanceIdDetail;
import com.amazonaws.services.xray.model.ResourceARNDetail;
import com.amazonaws.services.xray.model.ResponseTimeRootCause;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.TraceUser;
import com.amazonaws.services.xray.model.ValueWithServiceIds;
import com.amazonaws.services.xray.model.transform.TraceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private Date startTime;
    private Double duration;
    private Double responseTime;
    private Boolean hasFault;
    private Boolean hasError;
    private Boolean hasThrottle;
    private Boolean isPartial;
    private Http http;
    private Map<String, List<ValueWithServiceIds>> annotations;
    private List<TraceUser> users;
    private List<ServiceId> serviceIds;
    private List<ResourceARNDetail> resourceARNs;
    private List<InstanceIdDetail> instanceIds;
    private List<AvailabilityZoneDetail> availabilityZones;
    private ServiceId entryPoint;
    private List<FaultRootCause> faultRootCauses;
    private List<ErrorRootCause> errorRootCauses;
    private List<ResponseTimeRootCause> responseTimeRootCauses;
    private Integer revision;
    private Date matchedEventTime;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public TraceSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public TraceSummary withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Double getDuration() {
        return this.duration;
    }

    public TraceSummary withDuration(Double duration) {
        this.setDuration(duration);
        return this;
    }

    public void setResponseTime(Double responseTime) {
        this.responseTime = responseTime;
    }

    public Double getResponseTime() {
        return this.responseTime;
    }

    public TraceSummary withResponseTime(Double responseTime) {
        this.setResponseTime(responseTime);
        return this;
    }

    public void setHasFault(Boolean hasFault) {
        this.hasFault = hasFault;
    }

    public Boolean getHasFault() {
        return this.hasFault;
    }

    public TraceSummary withHasFault(Boolean hasFault) {
        this.setHasFault(hasFault);
        return this;
    }

    public Boolean isHasFault() {
        return this.hasFault;
    }

    public void setHasError(Boolean hasError) {
        this.hasError = hasError;
    }

    public Boolean getHasError() {
        return this.hasError;
    }

    public TraceSummary withHasError(Boolean hasError) {
        this.setHasError(hasError);
        return this;
    }

    public Boolean isHasError() {
        return this.hasError;
    }

    public void setHasThrottle(Boolean hasThrottle) {
        this.hasThrottle = hasThrottle;
    }

    public Boolean getHasThrottle() {
        return this.hasThrottle;
    }

    public TraceSummary withHasThrottle(Boolean hasThrottle) {
        this.setHasThrottle(hasThrottle);
        return this;
    }

    public Boolean isHasThrottle() {
        return this.hasThrottle;
    }

    public void setIsPartial(Boolean isPartial) {
        this.isPartial = isPartial;
    }

    public Boolean getIsPartial() {
        return this.isPartial;
    }

    public TraceSummary withIsPartial(Boolean isPartial) {
        this.setIsPartial(isPartial);
        return this;
    }

    public Boolean isPartial() {
        return this.isPartial;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public Http getHttp() {
        return this.http;
    }

    public TraceSummary withHttp(Http http) {
        this.setHttp(http);
        return this;
    }

    public Map<String, List<ValueWithServiceIds>> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, List<ValueWithServiceIds>> annotations) {
        this.annotations = annotations;
    }

    public TraceSummary withAnnotations(Map<String, List<ValueWithServiceIds>> annotations) {
        this.setAnnotations(annotations);
        return this;
    }

    public TraceSummary addAnnotationsEntry(String key, List<ValueWithServiceIds> value) {
        if (null == this.annotations) {
            this.annotations = new HashMap<String, List<ValueWithServiceIds>>();
        }
        if (this.annotations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.annotations.put(key, value);
        return this;
    }

    public TraceSummary clearAnnotationsEntries() {
        this.annotations = null;
        return this;
    }

    public List<TraceUser> getUsers() {
        return this.users;
    }

    public void setUsers(Collection<TraceUser> users) {
        if (users == null) {
            this.users = null;
            return;
        }
        this.users = new ArrayList<TraceUser>(users);
    }

    public TraceSummary withUsers(TraceUser ... users) {
        if (this.users == null) {
            this.setUsers(new ArrayList<TraceUser>(users.length));
        }
        for (TraceUser ele : users) {
            this.users.add(ele);
        }
        return this;
    }

    public TraceSummary withUsers(Collection<TraceUser> users) {
        this.setUsers(users);
        return this;
    }

    public List<ServiceId> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(Collection<ServiceId> serviceIds) {
        if (serviceIds == null) {
            this.serviceIds = null;
            return;
        }
        this.serviceIds = new ArrayList<ServiceId>(serviceIds);
    }

    public TraceSummary withServiceIds(ServiceId ... serviceIds) {
        if (this.serviceIds == null) {
            this.setServiceIds(new ArrayList<ServiceId>(serviceIds.length));
        }
        for (ServiceId ele : serviceIds) {
            this.serviceIds.add(ele);
        }
        return this;
    }

    public TraceSummary withServiceIds(Collection<ServiceId> serviceIds) {
        this.setServiceIds(serviceIds);
        return this;
    }

    public List<ResourceARNDetail> getResourceARNs() {
        return this.resourceARNs;
    }

    public void setResourceARNs(Collection<ResourceARNDetail> resourceARNs) {
        if (resourceARNs == null) {
            this.resourceARNs = null;
            return;
        }
        this.resourceARNs = new ArrayList<ResourceARNDetail>(resourceARNs);
    }

    public TraceSummary withResourceARNs(ResourceARNDetail ... resourceARNs) {
        if (this.resourceARNs == null) {
            this.setResourceARNs(new ArrayList<ResourceARNDetail>(resourceARNs.length));
        }
        for (ResourceARNDetail ele : resourceARNs) {
            this.resourceARNs.add(ele);
        }
        return this;
    }

    public TraceSummary withResourceARNs(Collection<ResourceARNDetail> resourceARNs) {
        this.setResourceARNs(resourceARNs);
        return this;
    }

    public List<InstanceIdDetail> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<InstanceIdDetail> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        this.instanceIds = new ArrayList<InstanceIdDetail>(instanceIds);
    }

    public TraceSummary withInstanceIds(InstanceIdDetail ... instanceIds) {
        if (this.instanceIds == null) {
            this.setInstanceIds(new ArrayList<InstanceIdDetail>(instanceIds.length));
        }
        for (InstanceIdDetail ele : instanceIds) {
            this.instanceIds.add(ele);
        }
        return this;
    }

    public TraceSummary withInstanceIds(Collection<InstanceIdDetail> instanceIds) {
        this.setInstanceIds(instanceIds);
        return this;
    }

    public List<AvailabilityZoneDetail> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZoneDetail> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new ArrayList<AvailabilityZoneDetail>(availabilityZones);
    }

    public TraceSummary withAvailabilityZones(AvailabilityZoneDetail ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new ArrayList<AvailabilityZoneDetail>(availabilityZones.length));
        }
        for (AvailabilityZoneDetail ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public TraceSummary withAvailabilityZones(Collection<AvailabilityZoneDetail> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setEntryPoint(ServiceId entryPoint) {
        this.entryPoint = entryPoint;
    }

    public ServiceId getEntryPoint() {
        return this.entryPoint;
    }

    public TraceSummary withEntryPoint(ServiceId entryPoint) {
        this.setEntryPoint(entryPoint);
        return this;
    }

    public List<FaultRootCause> getFaultRootCauses() {
        return this.faultRootCauses;
    }

    public void setFaultRootCauses(Collection<FaultRootCause> faultRootCauses) {
        if (faultRootCauses == null) {
            this.faultRootCauses = null;
            return;
        }
        this.faultRootCauses = new ArrayList<FaultRootCause>(faultRootCauses);
    }

    public TraceSummary withFaultRootCauses(FaultRootCause ... faultRootCauses) {
        if (this.faultRootCauses == null) {
            this.setFaultRootCauses(new ArrayList<FaultRootCause>(faultRootCauses.length));
        }
        for (FaultRootCause ele : faultRootCauses) {
            this.faultRootCauses.add(ele);
        }
        return this;
    }

    public TraceSummary withFaultRootCauses(Collection<FaultRootCause> faultRootCauses) {
        this.setFaultRootCauses(faultRootCauses);
        return this;
    }

    public List<ErrorRootCause> getErrorRootCauses() {
        return this.errorRootCauses;
    }

    public void setErrorRootCauses(Collection<ErrorRootCause> errorRootCauses) {
        if (errorRootCauses == null) {
            this.errorRootCauses = null;
            return;
        }
        this.errorRootCauses = new ArrayList<ErrorRootCause>(errorRootCauses);
    }

    public TraceSummary withErrorRootCauses(ErrorRootCause ... errorRootCauses) {
        if (this.errorRootCauses == null) {
            this.setErrorRootCauses(new ArrayList<ErrorRootCause>(errorRootCauses.length));
        }
        for (ErrorRootCause ele : errorRootCauses) {
            this.errorRootCauses.add(ele);
        }
        return this;
    }

    public TraceSummary withErrorRootCauses(Collection<ErrorRootCause> errorRootCauses) {
        this.setErrorRootCauses(errorRootCauses);
        return this;
    }

    public List<ResponseTimeRootCause> getResponseTimeRootCauses() {
        return this.responseTimeRootCauses;
    }

    public void setResponseTimeRootCauses(Collection<ResponseTimeRootCause> responseTimeRootCauses) {
        if (responseTimeRootCauses == null) {
            this.responseTimeRootCauses = null;
            return;
        }
        this.responseTimeRootCauses = new ArrayList<ResponseTimeRootCause>(responseTimeRootCauses);
    }

    public TraceSummary withResponseTimeRootCauses(ResponseTimeRootCause ... responseTimeRootCauses) {
        if (this.responseTimeRootCauses == null) {
            this.setResponseTimeRootCauses(new ArrayList<ResponseTimeRootCause>(responseTimeRootCauses.length));
        }
        for (ResponseTimeRootCause ele : responseTimeRootCauses) {
            this.responseTimeRootCauses.add(ele);
        }
        return this;
    }

    public TraceSummary withResponseTimeRootCauses(Collection<ResponseTimeRootCause> responseTimeRootCauses) {
        this.setResponseTimeRootCauses(responseTimeRootCauses);
        return this;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public TraceSummary withRevision(Integer revision) {
        this.setRevision(revision);
        return this;
    }

    public void setMatchedEventTime(Date matchedEventTime) {
        this.matchedEventTime = matchedEventTime;
    }

    public Date getMatchedEventTime() {
        return this.matchedEventTime;
    }

    public TraceSummary withMatchedEventTime(Date matchedEventTime) {
        this.setMatchedEventTime(matchedEventTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getResponseTime() != null) {
            sb.append("ResponseTime: ").append(this.getResponseTime()).append(",");
        }
        if (this.getHasFault() != null) {
            sb.append("HasFault: ").append(this.getHasFault()).append(",");
        }
        if (this.getHasError() != null) {
            sb.append("HasError: ").append(this.getHasError()).append(",");
        }
        if (this.getHasThrottle() != null) {
            sb.append("HasThrottle: ").append(this.getHasThrottle()).append(",");
        }
        if (this.getIsPartial() != null) {
            sb.append("IsPartial: ").append(this.getIsPartial()).append(",");
        }
        if (this.getHttp() != null) {
            sb.append("Http: ").append(this.getHttp()).append(",");
        }
        if (this.getAnnotations() != null) {
            sb.append("Annotations: ").append(this.getAnnotations()).append(",");
        }
        if (this.getUsers() != null) {
            sb.append("Users: ").append(this.getUsers()).append(",");
        }
        if (this.getServiceIds() != null) {
            sb.append("ServiceIds: ").append(this.getServiceIds()).append(",");
        }
        if (this.getResourceARNs() != null) {
            sb.append("ResourceARNs: ").append(this.getResourceARNs()).append(",");
        }
        if (this.getInstanceIds() != null) {
            sb.append("InstanceIds: ").append(this.getInstanceIds()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getEntryPoint() != null) {
            sb.append("EntryPoint: ").append(this.getEntryPoint()).append(",");
        }
        if (this.getFaultRootCauses() != null) {
            sb.append("FaultRootCauses: ").append(this.getFaultRootCauses()).append(",");
        }
        if (this.getErrorRootCauses() != null) {
            sb.append("ErrorRootCauses: ").append(this.getErrorRootCauses()).append(",");
        }
        if (this.getResponseTimeRootCauses() != null) {
            sb.append("ResponseTimeRootCauses: ").append(this.getResponseTimeRootCauses()).append(",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: ").append(this.getRevision()).append(",");
        }
        if (this.getMatchedEventTime() != null) {
            sb.append("MatchedEventTime: ").append(this.getMatchedEventTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceSummary)) {
            return false;
        }
        TraceSummary other = (TraceSummary)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getResponseTime() == null ^ this.getResponseTime() == null) {
            return false;
        }
        if (other.getResponseTime() != null && !other.getResponseTime().equals(this.getResponseTime())) {
            return false;
        }
        if (other.getHasFault() == null ^ this.getHasFault() == null) {
            return false;
        }
        if (other.getHasFault() != null && !other.getHasFault().equals(this.getHasFault())) {
            return false;
        }
        if (other.getHasError() == null ^ this.getHasError() == null) {
            return false;
        }
        if (other.getHasError() != null && !other.getHasError().equals(this.getHasError())) {
            return false;
        }
        if (other.getHasThrottle() == null ^ this.getHasThrottle() == null) {
            return false;
        }
        if (other.getHasThrottle() != null && !other.getHasThrottle().equals(this.getHasThrottle())) {
            return false;
        }
        if (other.getIsPartial() == null ^ this.getIsPartial() == null) {
            return false;
        }
        if (other.getIsPartial() != null && !other.getIsPartial().equals(this.getIsPartial())) {
            return false;
        }
        if (other.getHttp() == null ^ this.getHttp() == null) {
            return false;
        }
        if (other.getHttp() != null && !other.getHttp().equals(this.getHttp())) {
            return false;
        }
        if (other.getAnnotations() == null ^ this.getAnnotations() == null) {
            return false;
        }
        if (other.getAnnotations() != null && !other.getAnnotations().equals(this.getAnnotations())) {
            return false;
        }
        if (other.getUsers() == null ^ this.getUsers() == null) {
            return false;
        }
        if (other.getUsers() != null && !other.getUsers().equals(this.getUsers())) {
            return false;
        }
        if (other.getServiceIds() == null ^ this.getServiceIds() == null) {
            return false;
        }
        if (other.getServiceIds() != null && !other.getServiceIds().equals(this.getServiceIds())) {
            return false;
        }
        if (other.getResourceARNs() == null ^ this.getResourceARNs() == null) {
            return false;
        }
        if (other.getResourceARNs() != null && !other.getResourceARNs().equals(this.getResourceARNs())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        if (other.getInstanceIds() != null && !other.getInstanceIds().equals(this.getInstanceIds())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getEntryPoint() == null ^ this.getEntryPoint() == null) {
            return false;
        }
        if (other.getEntryPoint() != null && !other.getEntryPoint().equals(this.getEntryPoint())) {
            return false;
        }
        if (other.getFaultRootCauses() == null ^ this.getFaultRootCauses() == null) {
            return false;
        }
        if (other.getFaultRootCauses() != null && !other.getFaultRootCauses().equals(this.getFaultRootCauses())) {
            return false;
        }
        if (other.getErrorRootCauses() == null ^ this.getErrorRootCauses() == null) {
            return false;
        }
        if (other.getErrorRootCauses() != null && !other.getErrorRootCauses().equals(this.getErrorRootCauses())) {
            return false;
        }
        if (other.getResponseTimeRootCauses() == null ^ this.getResponseTimeRootCauses() == null) {
            return false;
        }
        if (other.getResponseTimeRootCauses() != null && !other.getResponseTimeRootCauses().equals(this.getResponseTimeRootCauses())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        if (other.getRevision() != null && !other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getMatchedEventTime() == null ^ this.getMatchedEventTime() == null) {
            return false;
        }
        return other.getMatchedEventTime() == null || other.getMatchedEventTime().equals(this.getMatchedEventTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getResponseTime() == null ? 0 : this.getResponseTime().hashCode());
        hashCode = 31 * hashCode + (this.getHasFault() == null ? 0 : this.getHasFault().hashCode());
        hashCode = 31 * hashCode + (this.getHasError() == null ? 0 : this.getHasError().hashCode());
        hashCode = 31 * hashCode + (this.getHasThrottle() == null ? 0 : this.getHasThrottle().hashCode());
        hashCode = 31 * hashCode + (this.getIsPartial() == null ? 0 : this.getIsPartial().hashCode());
        hashCode = 31 * hashCode + (this.getHttp() == null ? 0 : this.getHttp().hashCode());
        hashCode = 31 * hashCode + (this.getAnnotations() == null ? 0 : this.getAnnotations().hashCode());
        hashCode = 31 * hashCode + (this.getUsers() == null ? 0 : this.getUsers().hashCode());
        hashCode = 31 * hashCode + (this.getServiceIds() == null ? 0 : this.getServiceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceARNs() == null ? 0 : this.getResourceARNs().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : this.getInstanceIds().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getEntryPoint() == null ? 0 : this.getEntryPoint().hashCode());
        hashCode = 31 * hashCode + (this.getFaultRootCauses() == null ? 0 : this.getFaultRootCauses().hashCode());
        hashCode = 31 * hashCode + (this.getErrorRootCauses() == null ? 0 : this.getErrorRootCauses().hashCode());
        hashCode = 31 * hashCode + (this.getResponseTimeRootCauses() == null ? 0 : this.getResponseTimeRootCauses().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedEventTime() == null ? 0 : this.getMatchedEventTime().hashCode());
        return hashCode;
    }

    public TraceSummary clone() {
        try {
            return (TraceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

