/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.AnomalousService;
import com.amazonaws.services.xray.model.InsightCategory;
import com.amazonaws.services.xray.model.InsightState;
import com.amazonaws.services.xray.model.RequestImpactStatistics;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.transform.InsightMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Insight
implements Serializable,
Cloneable,
StructuredPojo {
    private String insightId;
    private String groupARN;
    private String groupName;
    private ServiceId rootCauseServiceId;
    private List<String> categories;
    private String state;
    private Date startTime;
    private Date endTime;
    private String summary;
    private RequestImpactStatistics clientRequestImpactStatistics;
    private RequestImpactStatistics rootCauseServiceRequestImpactStatistics;
    private List<AnomalousService> topAnomalousServices;

    public void setInsightId(String insightId) {
        this.insightId = insightId;
    }

    public String getInsightId() {
        return this.insightId;
    }

    public Insight withInsightId(String insightId) {
        this.setInsightId(insightId);
        return this;
    }

    public void setGroupARN(String groupARN) {
        this.groupARN = groupARN;
    }

    public String getGroupARN() {
        return this.groupARN;
    }

    public Insight withGroupARN(String groupARN) {
        this.setGroupARN(groupARN);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Insight withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setRootCauseServiceId(ServiceId rootCauseServiceId) {
        this.rootCauseServiceId = rootCauseServiceId;
    }

    public ServiceId getRootCauseServiceId() {
        return this.rootCauseServiceId;
    }

    public Insight withRootCauseServiceId(ServiceId rootCauseServiceId) {
        this.setRootCauseServiceId(rootCauseServiceId);
        return this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Collection<String> categories) {
        if (categories == null) {
            this.categories = null;
            return;
        }
        this.categories = new ArrayList<String>(categories);
    }

    public Insight withCategories(String ... categories) {
        if (this.categories == null) {
            this.setCategories(new ArrayList<String>(categories.length));
        }
        for (String ele : categories) {
            this.categories.add(ele);
        }
        return this;
    }

    public Insight withCategories(Collection<String> categories) {
        this.setCategories(categories);
        return this;
    }

    public Insight withCategories(InsightCategory ... categories) {
        ArrayList<String> categoriesCopy = new ArrayList<String>(categories.length);
        for (InsightCategory value : categories) {
            categoriesCopy.add(value.toString());
        }
        if (this.getCategories() == null) {
            this.setCategories(categoriesCopy);
        } else {
            this.getCategories().addAll(categoriesCopy);
        }
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Insight withState(String state) {
        this.setState(state);
        return this;
    }

    public Insight withState(InsightState state) {
        this.state = state.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Insight withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Insight withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public Insight withSummary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public void setClientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
        this.clientRequestImpactStatistics = clientRequestImpactStatistics;
    }

    public RequestImpactStatistics getClientRequestImpactStatistics() {
        return this.clientRequestImpactStatistics;
    }

    public Insight withClientRequestImpactStatistics(RequestImpactStatistics clientRequestImpactStatistics) {
        this.setClientRequestImpactStatistics(clientRequestImpactStatistics);
        return this;
    }

    public void setRootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
        this.rootCauseServiceRequestImpactStatistics = rootCauseServiceRequestImpactStatistics;
    }

    public RequestImpactStatistics getRootCauseServiceRequestImpactStatistics() {
        return this.rootCauseServiceRequestImpactStatistics;
    }

    public Insight withRootCauseServiceRequestImpactStatistics(RequestImpactStatistics rootCauseServiceRequestImpactStatistics) {
        this.setRootCauseServiceRequestImpactStatistics(rootCauseServiceRequestImpactStatistics);
        return this;
    }

    public List<AnomalousService> getTopAnomalousServices() {
        return this.topAnomalousServices;
    }

    public void setTopAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
        if (topAnomalousServices == null) {
            this.topAnomalousServices = null;
            return;
        }
        this.topAnomalousServices = new ArrayList<AnomalousService>(topAnomalousServices);
    }

    public Insight withTopAnomalousServices(AnomalousService ... topAnomalousServices) {
        if (this.topAnomalousServices == null) {
            this.setTopAnomalousServices(new ArrayList<AnomalousService>(topAnomalousServices.length));
        }
        for (AnomalousService ele : topAnomalousServices) {
            this.topAnomalousServices.add(ele);
        }
        return this;
    }

    public Insight withTopAnomalousServices(Collection<AnomalousService> topAnomalousServices) {
        this.setTopAnomalousServices(topAnomalousServices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInsightId() != null) {
            sb.append("InsightId: ").append(this.getInsightId()).append(",");
        }
        if (this.getGroupARN() != null) {
            sb.append("GroupARN: ").append(this.getGroupARN()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getRootCauseServiceId() != null) {
            sb.append("RootCauseServiceId: ").append(this.getRootCauseServiceId()).append(",");
        }
        if (this.getCategories() != null) {
            sb.append("Categories: ").append(this.getCategories()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getClientRequestImpactStatistics() != null) {
            sb.append("ClientRequestImpactStatistics: ").append(this.getClientRequestImpactStatistics()).append(",");
        }
        if (this.getRootCauseServiceRequestImpactStatistics() != null) {
            sb.append("RootCauseServiceRequestImpactStatistics: ").append(this.getRootCauseServiceRequestImpactStatistics()).append(",");
        }
        if (this.getTopAnomalousServices() != null) {
            sb.append("TopAnomalousServices: ").append(this.getTopAnomalousServices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)obj;
        if (other.getInsightId() == null ^ this.getInsightId() == null) {
            return false;
        }
        if (other.getInsightId() != null && !other.getInsightId().equals(this.getInsightId())) {
            return false;
        }
        if (other.getGroupARN() == null ^ this.getGroupARN() == null) {
            return false;
        }
        if (other.getGroupARN() != null && !other.getGroupARN().equals(this.getGroupARN())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getRootCauseServiceId() == null ^ this.getRootCauseServiceId() == null) {
            return false;
        }
        if (other.getRootCauseServiceId() != null && !other.getRootCauseServiceId().equals(this.getRootCauseServiceId())) {
            return false;
        }
        if (other.getCategories() == null ^ this.getCategories() == null) {
            return false;
        }
        if (other.getCategories() != null && !other.getCategories().equals(this.getCategories())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getClientRequestImpactStatistics() == null ^ this.getClientRequestImpactStatistics() == null) {
            return false;
        }
        if (other.getClientRequestImpactStatistics() != null && !other.getClientRequestImpactStatistics().equals(this.getClientRequestImpactStatistics())) {
            return false;
        }
        if (other.getRootCauseServiceRequestImpactStatistics() == null ^ this.getRootCauseServiceRequestImpactStatistics() == null) {
            return false;
        }
        if (other.getRootCauseServiceRequestImpactStatistics() != null && !other.getRootCauseServiceRequestImpactStatistics().equals(this.getRootCauseServiceRequestImpactStatistics())) {
            return false;
        }
        if (other.getTopAnomalousServices() == null ^ this.getTopAnomalousServices() == null) {
            return false;
        }
        return other.getTopAnomalousServices() == null || other.getTopAnomalousServices().equals(this.getTopAnomalousServices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInsightId() == null ? 0 : this.getInsightId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupARN() == null ? 0 : this.getGroupARN().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getRootCauseServiceId() == null ? 0 : this.getRootCauseServiceId().hashCode());
        hashCode = 31 * hashCode + (this.getCategories() == null ? 0 : this.getCategories().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestImpactStatistics() == null ? 0 : this.getClientRequestImpactStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getRootCauseServiceRequestImpactStatistics() == null ? 0 : this.getRootCauseServiceRequestImpactStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTopAnomalousServices() == null ? 0 : this.getTopAnomalousServices().hashCode());
        return hashCode;
    }

    public Insight clone() {
        try {
            return (Insight)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

