/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.xray.model.InsightState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetInsightSummariesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> states;
    private String groupARN;
    private String groupName;
    private Date startTime;
    private Date endTime;
    private Integer maxResults;
    private String nextToken;

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public GetInsightSummariesRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public GetInsightSummariesRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public GetInsightSummariesRequest withStates(InsightState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (InsightState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public void setGroupARN(String groupARN) {
        this.groupARN = groupARN;
    }

    public String getGroupARN() {
        return this.groupARN;
    }

    public GetInsightSummariesRequest withGroupARN(String groupARN) {
        this.setGroupARN(groupARN);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GetInsightSummariesRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetInsightSummariesRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetInsightSummariesRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetInsightSummariesRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetInsightSummariesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getGroupARN() != null) {
            sb.append("GroupARN: ").append(this.getGroupARN()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightSummariesRequest)) {
            return false;
        }
        GetInsightSummariesRequest other = (GetInsightSummariesRequest)obj;
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getGroupARN() == null ^ this.getGroupARN() == null) {
            return false;
        }
        if (other.getGroupARN() != null && !other.getGroupARN().equals(this.getGroupARN())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getGroupARN() == null ? 0 : this.getGroupARN().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public GetInsightSummariesRequest clone() {
        return (GetInsightSummariesRequest)super.clone();
    }
}

