/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.Tag;
import com.amazonaws.services.workspaces.model.WorkspaceProperties;
import com.amazonaws.services.workspaces.model.transform.WorkspaceRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class WorkspaceRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String directoryId;
    private String userName;
    private String bundleId;
    private String volumeEncryptionKey;
    private Boolean userVolumeEncryptionEnabled;
    private Boolean rootVolumeEncryptionEnabled;
    private WorkspaceProperties workspaceProperties;
    private SdkInternalList<Tag> tags;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public WorkspaceRequest withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public WorkspaceRequest withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public WorkspaceRequest withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setVolumeEncryptionKey(String volumeEncryptionKey) {
        this.volumeEncryptionKey = volumeEncryptionKey;
    }

    public String getVolumeEncryptionKey() {
        return this.volumeEncryptionKey;
    }

    public WorkspaceRequest withVolumeEncryptionKey(String volumeEncryptionKey) {
        this.setVolumeEncryptionKey(volumeEncryptionKey);
        return this;
    }

    public void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
        this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
    }

    public Boolean getUserVolumeEncryptionEnabled() {
        return this.userVolumeEncryptionEnabled;
    }

    public WorkspaceRequest withUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
        this.setUserVolumeEncryptionEnabled(userVolumeEncryptionEnabled);
        return this;
    }

    public Boolean isUserVolumeEncryptionEnabled() {
        return this.userVolumeEncryptionEnabled;
    }

    public void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
        this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
    }

    public Boolean getRootVolumeEncryptionEnabled() {
        return this.rootVolumeEncryptionEnabled;
    }

    public WorkspaceRequest withRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
        this.setRootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled);
        return this;
    }

    public Boolean isRootVolumeEncryptionEnabled() {
        return this.rootVolumeEncryptionEnabled;
    }

    public void setWorkspaceProperties(WorkspaceProperties workspaceProperties) {
        this.workspaceProperties = workspaceProperties;
    }

    public WorkspaceProperties getWorkspaceProperties() {
        return this.workspaceProperties;
    }

    public WorkspaceRequest withWorkspaceProperties(WorkspaceProperties workspaceProperties) {
        this.setWorkspaceProperties(workspaceProperties);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public WorkspaceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public WorkspaceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getVolumeEncryptionKey() != null) {
            sb.append("VolumeEncryptionKey: ").append(this.getVolumeEncryptionKey()).append(",");
        }
        if (this.getUserVolumeEncryptionEnabled() != null) {
            sb.append("UserVolumeEncryptionEnabled: ").append(this.getUserVolumeEncryptionEnabled()).append(",");
        }
        if (this.getRootVolumeEncryptionEnabled() != null) {
            sb.append("RootVolumeEncryptionEnabled: ").append(this.getRootVolumeEncryptionEnabled()).append(",");
        }
        if (this.getWorkspaceProperties() != null) {
            sb.append("WorkspaceProperties: ").append(this.getWorkspaceProperties()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceRequest)) {
            return false;
        }
        WorkspaceRequest other = (WorkspaceRequest)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getVolumeEncryptionKey() == null ^ this.getVolumeEncryptionKey() == null) {
            return false;
        }
        if (other.getVolumeEncryptionKey() != null && !other.getVolumeEncryptionKey().equals(this.getVolumeEncryptionKey())) {
            return false;
        }
        if (other.getUserVolumeEncryptionEnabled() == null ^ this.getUserVolumeEncryptionEnabled() == null) {
            return false;
        }
        if (other.getUserVolumeEncryptionEnabled() != null && !other.getUserVolumeEncryptionEnabled().equals(this.getUserVolumeEncryptionEnabled())) {
            return false;
        }
        if (other.getRootVolumeEncryptionEnabled() == null ^ this.getRootVolumeEncryptionEnabled() == null) {
            return false;
        }
        if (other.getRootVolumeEncryptionEnabled() != null && !other.getRootVolumeEncryptionEnabled().equals(this.getRootVolumeEncryptionEnabled())) {
            return false;
        }
        if (other.getWorkspaceProperties() == null ^ this.getWorkspaceProperties() == null) {
            return false;
        }
        if (other.getWorkspaceProperties() != null && !other.getWorkspaceProperties().equals(this.getWorkspaceProperties())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeEncryptionKey() == null ? 0 : this.getVolumeEncryptionKey().hashCode());
        hashCode = 31 * hashCode + (this.getUserVolumeEncryptionEnabled() == null ? 0 : this.getUserVolumeEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getRootVolumeEncryptionEnabled() == null ? 0 : this.getRootVolumeEncryptionEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getWorkspaceProperties() == null ? 0 : this.getWorkspaceProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public WorkspaceRequest clone() {
        try {
            return (WorkspaceRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkspaceRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

