/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workdocs.model.SharePrincipal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddResourcePermissionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceId;
    private List<SharePrincipal> principals;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public AddResourcePermissionsRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public List<SharePrincipal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<SharePrincipal> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<SharePrincipal>(principals);
    }

    public AddResourcePermissionsRequest withPrincipals(SharePrincipal ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<SharePrincipal>(principals.length));
        }
        for (SharePrincipal ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public AddResourcePermissionsRequest withPrincipals(Collection<SharePrincipal> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddResourcePermissionsRequest)) {
            return false;
        }
        AddResourcePermissionsRequest other = (AddResourcePermissionsRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        return other.getPrincipals() == null || other.getPrincipals().equals(this.getPrincipals());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        return hashCode;
    }

    public AddResourcePermissionsRequest clone() {
        return (AddResourcePermissionsRequest)super.clone();
    }
}

