/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.RuleUpdate;
import com.amazonaws.services.waf.model.UpdateRuleRequest;
import com.amazonaws.services.waf.model.transform.RuleUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateRuleRequestMarshaller
implements Marshaller<Request<UpdateRuleRequest>, UpdateRuleRequest> {
    public Request<UpdateRuleRequest> marshall(UpdateRuleRequest updateRuleRequest) {
        if (updateRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateRuleRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<RuleUpdate> updatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateRuleRequest.getRuleId() != null) {
                jsonWriter.key("RuleId").value((Object)updateRuleRequest.getRuleId());
            }
            if (updateRuleRequest.getChangeToken() != null) {
                jsonWriter.key("ChangeToken").value((Object)updateRuleRequest.getChangeToken());
            }
            if ((updatesList = updateRuleRequest.getUpdates()) != null) {
                jsonWriter.key("Updates");
                jsonWriter.array();
                for (RuleUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    RuleUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

