/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.SizeConstraint;
import com.amazonaws.services.waf.model.SizeConstraintSet;
import com.amazonaws.services.waf.model.transform.SizeConstraintJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class SizeConstraintSetJsonMarshaller {
    private static SizeConstraintSetJsonMarshaller instance;

    public void marshall(SizeConstraintSet sizeConstraintSet, JSONWriter jsonWriter) {
        if (sizeConstraintSet == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<SizeConstraint> sizeConstraintsList;
            jsonWriter.object();
            if (sizeConstraintSet.getSizeConstraintSetId() != null) {
                jsonWriter.key("SizeConstraintSetId").value((Object)sizeConstraintSet.getSizeConstraintSetId());
            }
            if (sizeConstraintSet.getName() != null) {
                jsonWriter.key("Name").value((Object)sizeConstraintSet.getName());
            }
            if ((sizeConstraintsList = sizeConstraintSet.getSizeConstraints()) != null) {
                jsonWriter.key("SizeConstraints");
                jsonWriter.array();
                for (SizeConstraint sizeConstraintsListValue : sizeConstraintsList) {
                    if (sizeConstraintsListValue == null) continue;
                    SizeConstraintJsonMarshaller.getInstance().marshall(sizeConstraintsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SizeConstraintSetJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SizeConstraintSetJsonMarshaller();
        }
        return instance;
    }
}

