/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.waf.model.HTTPHeader;
import com.amazonaws.services.waf.model.HTTPRequest;
import com.amazonaws.services.waf.model.transform.HTTPHeaderJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class HTTPRequestJsonMarshaller {
    private static HTTPRequestJsonMarshaller instance;

    public void marshall(HTTPRequest hTTPRequest, JSONWriter jsonWriter) {
        if (hTTPRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<HTTPHeader> headersList;
            jsonWriter.object();
            if (hTTPRequest.getClientIP() != null) {
                jsonWriter.key("ClientIP").value((Object)hTTPRequest.getClientIP());
            }
            if (hTTPRequest.getCountry() != null) {
                jsonWriter.key("Country").value((Object)hTTPRequest.getCountry());
            }
            if (hTTPRequest.getURI() != null) {
                jsonWriter.key("URI").value((Object)hTTPRequest.getURI());
            }
            if (hTTPRequest.getMethod() != null) {
                jsonWriter.key("Method").value((Object)hTTPRequest.getMethod());
            }
            if (hTTPRequest.getHTTPVersion() != null) {
                jsonWriter.key("HTTPVersion").value((Object)hTTPRequest.getHTTPVersion());
            }
            if ((headersList = hTTPRequest.getHeaders()) != null) {
                jsonWriter.key("Headers");
                jsonWriter.array();
                for (HTTPHeader headersListValue : headersList) {
                    if (headersListValue == null) continue;
                    HTTPHeaderJsonMarshaller.getInstance().marshall(headersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HTTPRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HTTPRequestJsonMarshaller();
        }
        return instance;
    }
}

