/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.translate.model.ParallelDataConfig;

@SdkInternalApi
public class ParallelDataConfigMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").build();
    private static final ParallelDataConfigMarshaller instance = new ParallelDataConfigMarshaller();

    public static ParallelDataConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParallelDataConfig parallelDataConfig, ProtocolMarshaller protocolMarshaller) {
        if (parallelDataConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)parallelDataConfig.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall((Object)parallelDataConfig.getFormat(), FORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

