/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.DetectedSignature;
import com.amazonaws.services.textract.model.SplitDocument;
import com.amazonaws.services.textract.model.UndetectedSignature;
import com.amazonaws.services.textract.model.transform.DocumentGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private List<SplitDocument> splitDocuments;
    private List<DetectedSignature> detectedSignatures;
    private List<UndetectedSignature> undetectedSignatures;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DocumentGroup withType(String type) {
        this.setType(type);
        return this;
    }

    public List<SplitDocument> getSplitDocuments() {
        return this.splitDocuments;
    }

    public void setSplitDocuments(Collection<SplitDocument> splitDocuments) {
        if (splitDocuments == null) {
            this.splitDocuments = null;
            return;
        }
        this.splitDocuments = new ArrayList<SplitDocument>(splitDocuments);
    }

    public DocumentGroup withSplitDocuments(SplitDocument ... splitDocuments) {
        if (this.splitDocuments == null) {
            this.setSplitDocuments(new ArrayList<SplitDocument>(splitDocuments.length));
        }
        for (SplitDocument ele : splitDocuments) {
            this.splitDocuments.add(ele);
        }
        return this;
    }

    public DocumentGroup withSplitDocuments(Collection<SplitDocument> splitDocuments) {
        this.setSplitDocuments(splitDocuments);
        return this;
    }

    public List<DetectedSignature> getDetectedSignatures() {
        return this.detectedSignatures;
    }

    public void setDetectedSignatures(Collection<DetectedSignature> detectedSignatures) {
        if (detectedSignatures == null) {
            this.detectedSignatures = null;
            return;
        }
        this.detectedSignatures = new ArrayList<DetectedSignature>(detectedSignatures);
    }

    public DocumentGroup withDetectedSignatures(DetectedSignature ... detectedSignatures) {
        if (this.detectedSignatures == null) {
            this.setDetectedSignatures(new ArrayList<DetectedSignature>(detectedSignatures.length));
        }
        for (DetectedSignature ele : detectedSignatures) {
            this.detectedSignatures.add(ele);
        }
        return this;
    }

    public DocumentGroup withDetectedSignatures(Collection<DetectedSignature> detectedSignatures) {
        this.setDetectedSignatures(detectedSignatures);
        return this;
    }

    public List<UndetectedSignature> getUndetectedSignatures() {
        return this.undetectedSignatures;
    }

    public void setUndetectedSignatures(Collection<UndetectedSignature> undetectedSignatures) {
        if (undetectedSignatures == null) {
            this.undetectedSignatures = null;
            return;
        }
        this.undetectedSignatures = new ArrayList<UndetectedSignature>(undetectedSignatures);
    }

    public DocumentGroup withUndetectedSignatures(UndetectedSignature ... undetectedSignatures) {
        if (this.undetectedSignatures == null) {
            this.setUndetectedSignatures(new ArrayList<UndetectedSignature>(undetectedSignatures.length));
        }
        for (UndetectedSignature ele : undetectedSignatures) {
            this.undetectedSignatures.add(ele);
        }
        return this;
    }

    public DocumentGroup withUndetectedSignatures(Collection<UndetectedSignature> undetectedSignatures) {
        this.setUndetectedSignatures(undetectedSignatures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSplitDocuments() != null) {
            sb.append("SplitDocuments: ").append(this.getSplitDocuments()).append(",");
        }
        if (this.getDetectedSignatures() != null) {
            sb.append("DetectedSignatures: ").append(this.getDetectedSignatures()).append(",");
        }
        if (this.getUndetectedSignatures() != null) {
            sb.append("UndetectedSignatures: ").append(this.getUndetectedSignatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentGroup)) {
            return false;
        }
        DocumentGroup other = (DocumentGroup)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSplitDocuments() == null ^ this.getSplitDocuments() == null) {
            return false;
        }
        if (other.getSplitDocuments() != null && !other.getSplitDocuments().equals(this.getSplitDocuments())) {
            return false;
        }
        if (other.getDetectedSignatures() == null ^ this.getDetectedSignatures() == null) {
            return false;
        }
        if (other.getDetectedSignatures() != null && !other.getDetectedSignatures().equals(this.getDetectedSignatures())) {
            return false;
        }
        if (other.getUndetectedSignatures() == null ^ this.getUndetectedSignatures() == null) {
            return false;
        }
        return other.getUndetectedSignatures() == null || other.getUndetectedSignatures().equals(this.getUndetectedSignatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSplitDocuments() == null ? 0 : this.getSplitDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getDetectedSignatures() == null ? 0 : this.getDetectedSignatures().hashCode());
        hashCode = 31 * hashCode + (this.getUndetectedSignatures() == null ? 0 : this.getUndetectedSignatures().hashCode());
        return hashCode;
    }

    public DocumentGroup clone() {
        try {
            return (DocumentGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

