/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.storagegateway.model.TapeArchive;
import java.util.Date;

@SdkInternalApi
public class TapeArchiveMarshaller {
    private static final MarshallingInfo<String> TAPEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeARN").build();
    private static final MarshallingInfo<String> TAPEBARCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeBarcode").build();
    private static final MarshallingInfo<Date> TAPECREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeCreatedDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Long> TAPESIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeSizeInBytes").build();
    private static final MarshallingInfo<Date> COMPLETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RETRIEVEDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetrievedTo").build();
    private static final MarshallingInfo<String> TAPESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeStatus").build();
    private static final MarshallingInfo<Long> TAPEUSEDINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TapeUsedInBytes").build();
    private static final MarshallingInfo<String> KMSKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KMSKey").build();
    private static final MarshallingInfo<String> POOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PoolId").build();
    private static final TapeArchiveMarshaller instance = new TapeArchiveMarshaller();

    public static TapeArchiveMarshaller getInstance() {
        return instance;
    }

    public void marshall(TapeArchive tapeArchive, ProtocolMarshaller protocolMarshaller) {
        if (tapeArchive == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tapeArchive.getTapeARN(), TAPEARN_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getTapeBarcode(), TAPEBARCODE_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getTapeCreatedDate(), TAPECREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getTapeSizeInBytes(), TAPESIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getCompletionTime(), COMPLETIONTIME_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getRetrievedTo(), RETRIEVEDTO_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getTapeStatus(), TAPESTATUS_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getTapeUsedInBytes(), TAPEUSEDINBYTES_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getKMSKey(), KMSKEY_BINDING);
            protocolMarshaller.marshall((Object)tapeArchive.getPoolId(), POOLID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

