/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.stepfunctions.model.LogDestination;
import com.amazonaws.services.stepfunctions.model.LogLevel;
import com.amazonaws.services.stepfunctions.model.transform.LoggingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String level;
    private Boolean includeExecutionData;
    private List<LogDestination> destinations;

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public LoggingConfiguration withLevel(String level) {
        this.setLevel(level);
        return this;
    }

    public LoggingConfiguration withLevel(LogLevel level) {
        this.level = level.toString();
        return this;
    }

    public void setIncludeExecutionData(Boolean includeExecutionData) {
        this.includeExecutionData = includeExecutionData;
    }

    public Boolean getIncludeExecutionData() {
        return this.includeExecutionData;
    }

    public LoggingConfiguration withIncludeExecutionData(Boolean includeExecutionData) {
        this.setIncludeExecutionData(includeExecutionData);
        return this;
    }

    public Boolean isIncludeExecutionData() {
        return this.includeExecutionData;
    }

    public List<LogDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<LogDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<LogDestination>(destinations);
    }

    public LoggingConfiguration withDestinations(LogDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<LogDestination>(destinations.length));
        }
        for (LogDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public LoggingConfiguration withDestinations(Collection<LogDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLevel() != null) {
            sb.append("Level: ").append(this.getLevel()).append(",");
        }
        if (this.getIncludeExecutionData() != null) {
            sb.append("IncludeExecutionData: ").append(this.getIncludeExecutionData()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        if (other.getLevel() == null ^ this.getLevel() == null) {
            return false;
        }
        if (other.getLevel() != null && !other.getLevel().equals(this.getLevel())) {
            return false;
        }
        if (other.getIncludeExecutionData() == null ^ this.getIncludeExecutionData() == null) {
            return false;
        }
        if (other.getIncludeExecutionData() != null && !other.getIncludeExecutionData().equals(this.getIncludeExecutionData())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLevel() == null ? 0 : this.getLevel().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeExecutionData() == null ? 0 : this.getIncludeExecutionData().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public LoggingConfiguration clone() {
        try {
            return (LoggingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

