/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmincidents.model.NotificationTargetItem;
import com.amazonaws.services.ssmincidents.model.transform.IncidentTemplateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncidentTemplate
implements Serializable,
Cloneable,
StructuredPojo {
    private String dedupeString;
    private Integer impact;
    private Map<String, String> incidentTags;
    private List<NotificationTargetItem> notificationTargets;
    private String summary;
    private String title;

    public void setDedupeString(String dedupeString) {
        this.dedupeString = dedupeString;
    }

    public String getDedupeString() {
        return this.dedupeString;
    }

    public IncidentTemplate withDedupeString(String dedupeString) {
        this.setDedupeString(dedupeString);
        return this;
    }

    public void setImpact(Integer impact) {
        this.impact = impact;
    }

    public Integer getImpact() {
        return this.impact;
    }

    public IncidentTemplate withImpact(Integer impact) {
        this.setImpact(impact);
        return this;
    }

    public Map<String, String> getIncidentTags() {
        return this.incidentTags;
    }

    public void setIncidentTags(Map<String, String> incidentTags) {
        this.incidentTags = incidentTags;
    }

    public IncidentTemplate withIncidentTags(Map<String, String> incidentTags) {
        this.setIncidentTags(incidentTags);
        return this;
    }

    public IncidentTemplate addIncidentTagsEntry(String key, String value) {
        if (null == this.incidentTags) {
            this.incidentTags = new HashMap<String, String>();
        }
        if (this.incidentTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.incidentTags.put(key, value);
        return this;
    }

    public IncidentTemplate clearIncidentTagsEntries() {
        this.incidentTags = null;
        return this;
    }

    public List<NotificationTargetItem> getNotificationTargets() {
        return this.notificationTargets;
    }

    public void setNotificationTargets(Collection<NotificationTargetItem> notificationTargets) {
        if (notificationTargets == null) {
            this.notificationTargets = null;
            return;
        }
        this.notificationTargets = new ArrayList<NotificationTargetItem>(notificationTargets);
    }

    public IncidentTemplate withNotificationTargets(NotificationTargetItem ... notificationTargets) {
        if (this.notificationTargets == null) {
            this.setNotificationTargets(new ArrayList<NotificationTargetItem>(notificationTargets.length));
        }
        for (NotificationTargetItem ele : notificationTargets) {
            this.notificationTargets.add(ele);
        }
        return this;
    }

    public IncidentTemplate withNotificationTargets(Collection<NotificationTargetItem> notificationTargets) {
        this.setNotificationTargets(notificationTargets);
        return this;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public IncidentTemplate withSummary(String summary) {
        this.setSummary(summary);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public IncidentTemplate withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDedupeString() != null) {
            sb.append("DedupeString: ").append(this.getDedupeString()).append(",");
        }
        if (this.getImpact() != null) {
            sb.append("Impact: ").append(this.getImpact()).append(",");
        }
        if (this.getIncidentTags() != null) {
            sb.append("IncidentTags: ").append(this.getIncidentTags()).append(",");
        }
        if (this.getNotificationTargets() != null) {
            sb.append("NotificationTargets: ").append(this.getNotificationTargets()).append(",");
        }
        if (this.getSummary() != null) {
            sb.append("Summary: ").append(this.getSummary()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentTemplate)) {
            return false;
        }
        IncidentTemplate other = (IncidentTemplate)obj;
        if (other.getDedupeString() == null ^ this.getDedupeString() == null) {
            return false;
        }
        if (other.getDedupeString() != null && !other.getDedupeString().equals(this.getDedupeString())) {
            return false;
        }
        if (other.getImpact() == null ^ this.getImpact() == null) {
            return false;
        }
        if (other.getImpact() != null && !other.getImpact().equals(this.getImpact())) {
            return false;
        }
        if (other.getIncidentTags() == null ^ this.getIncidentTags() == null) {
            return false;
        }
        if (other.getIncidentTags() != null && !other.getIncidentTags().equals(this.getIncidentTags())) {
            return false;
        }
        if (other.getNotificationTargets() == null ^ this.getNotificationTargets() == null) {
            return false;
        }
        if (other.getNotificationTargets() != null && !other.getNotificationTargets().equals(this.getNotificationTargets())) {
            return false;
        }
        if (other.getSummary() == null ^ this.getSummary() == null) {
            return false;
        }
        if (other.getSummary() != null && !other.getSummary().equals(this.getSummary())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        return other.getTitle() == null || other.getTitle().equals(this.getTitle());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDedupeString() == null ? 0 : this.getDedupeString().hashCode());
        hashCode = 31 * hashCode + (this.getImpact() == null ? 0 : this.getImpact().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTags() == null ? 0 : this.getIncidentTags().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationTargets() == null ? 0 : this.getNotificationTargets().hashCode());
        hashCode = 31 * hashCode + (this.getSummary() == null ? 0 : this.getSummary().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        return hashCode;
    }

    public IncidentTemplate clone() {
        try {
            return (IncidentTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IncidentTemplateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

