/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryGroup;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryAggregatorMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InventoryAggregator
implements Serializable,
Cloneable,
StructuredPojo {
    private String expression;
    private SdkInternalList<InventoryAggregator> aggregators;
    private SdkInternalList<InventoryGroup> groups;

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public InventoryAggregator withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public List<InventoryAggregator> getAggregators() {
        if (this.aggregators == null) {
            this.aggregators = new SdkInternalList();
        }
        return this.aggregators;
    }

    public void setAggregators(Collection<InventoryAggregator> aggregators) {
        if (aggregators == null) {
            this.aggregators = null;
            return;
        }
        this.aggregators = new SdkInternalList(aggregators);
    }

    public InventoryAggregator withAggregators(InventoryAggregator ... aggregators) {
        if (this.aggregators == null) {
            this.setAggregators((Collection<InventoryAggregator>)new SdkInternalList(aggregators.length));
        }
        for (InventoryAggregator ele : aggregators) {
            this.aggregators.add((Object)ele);
        }
        return this;
    }

    public InventoryAggregator withAggregators(Collection<InventoryAggregator> aggregators) {
        this.setAggregators(aggregators);
        return this;
    }

    public List<InventoryGroup> getGroups() {
        if (this.groups == null) {
            this.groups = new SdkInternalList();
        }
        return this.groups;
    }

    public void setGroups(Collection<InventoryGroup> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new SdkInternalList(groups);
    }

    public InventoryAggregator withGroups(InventoryGroup ... groups) {
        if (this.groups == null) {
            this.setGroups((Collection<InventoryGroup>)new SdkInternalList(groups.length));
        }
        for (InventoryGroup ele : groups) {
            this.groups.add((Object)ele);
        }
        return this;
    }

    public InventoryAggregator withGroups(Collection<InventoryGroup> groups) {
        this.setGroups(groups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExpression() != null) {
            sb.append("Expression: ").append(this.getExpression()).append(",");
        }
        if (this.getAggregators() != null) {
            sb.append("Aggregators: ").append(this.getAggregators()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryAggregator)) {
            return false;
        }
        InventoryAggregator other = (InventoryAggregator)obj;
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getAggregators() == null ^ this.getAggregators() == null) {
            return false;
        }
        if (other.getAggregators() != null && !other.getAggregators().equals(this.getAggregators())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        return other.getGroups() == null || other.getGroups().equals(this.getGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getAggregators() == null ? 0 : this.getAggregators().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        return hashCode;
    }

    public InventoryAggregator clone() {
        try {
            return (InventoryAggregator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryAggregatorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

