/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.MetadataValue;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateOpsMetadataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceId;
    private Map<String, MetadataValue> metadata;
    private SdkInternalList<Tag> tags;

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public CreateOpsMetadataRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public Map<String, MetadataValue> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, MetadataValue> metadata) {
        this.metadata = metadata;
    }

    public CreateOpsMetadataRequest withMetadata(Map<String, MetadataValue> metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public CreateOpsMetadataRequest addMetadataEntry(String key, MetadataValue value) {
        if (null == this.metadata) {
            this.metadata = new HashMap<String, MetadataValue>();
        }
        if (this.metadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metadata.put(key, value);
        return this;
    }

    public CreateOpsMetadataRequest clearMetadataEntries() {
        this.metadata = null;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateOpsMetadataRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateOpsMetadataRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: ").append(this.getResourceId()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append(this.getMetadata()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpsMetadataRequest)) {
            return false;
        }
        CreateOpsMetadataRequest other = (CreateOpsMetadataRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateOpsMetadataRequest clone() {
        return (CreateOpsMetadataRequest)super.clone();
    }
}

