/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.LoggingInfo;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskInvocationParameters;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskParameterValueExpression;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowTaskType;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterTaskWithMaintenanceWindowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String windowId;
    private SdkInternalList<Target> targets;
    private String taskArn;
    private String serviceRoleArn;
    private String taskType;
    private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
    private Integer priority;
    private String maxConcurrency;
    private String maxErrors;
    private LoggingInfo loggingInfo;
    private String name;
    private String description;
    private String clientToken;

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public RegisterTaskWithMaintenanceWindowRequest withWindowId(String windowId) {
        this.setWindowId(windowId);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public RegisterTaskWithMaintenanceWindowRequest withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public RegisterTaskWithMaintenanceWindowRequest withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public RegisterTaskWithMaintenanceWindowRequest withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public RegisterTaskWithMaintenanceWindowRequest withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public RegisterTaskWithMaintenanceWindowRequest withTaskType(String taskType) {
        this.setTaskType(taskType);
        return this;
    }

    public void setTaskType(MaintenanceWindowTaskType taskType) {
        this.withTaskType(taskType);
    }

    public RegisterTaskWithMaintenanceWindowRequest withTaskType(MaintenanceWindowTaskType taskType) {
        this.taskType = taskType.toString();
        return this;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> getTaskParameters() {
        return this.taskParameters;
    }

    public void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
        this.taskParameters = taskParameters;
    }

    public RegisterTaskWithMaintenanceWindowRequest withTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
        this.setTaskParameters(taskParameters);
        return this;
    }

    public RegisterTaskWithMaintenanceWindowRequest addTaskParametersEntry(String key, MaintenanceWindowTaskParameterValueExpression value) {
        if (null == this.taskParameters) {
            this.taskParameters = new HashMap<String, MaintenanceWindowTaskParameterValueExpression>();
        }
        if (this.taskParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.taskParameters.put(key, value);
        return this;
    }

    public RegisterTaskWithMaintenanceWindowRequest clearTaskParametersEntries() {
        this.taskParameters = null;
        return this;
    }

    public void setTaskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
        this.taskInvocationParameters = taskInvocationParameters;
    }

    public MaintenanceWindowTaskInvocationParameters getTaskInvocationParameters() {
        return this.taskInvocationParameters;
    }

    public RegisterTaskWithMaintenanceWindowRequest withTaskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
        this.setTaskInvocationParameters(taskInvocationParameters);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public RegisterTaskWithMaintenanceWindowRequest withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public void setMaxConcurrency(String maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public String getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public RegisterTaskWithMaintenanceWindowRequest withMaxConcurrency(String maxConcurrency) {
        this.setMaxConcurrency(maxConcurrency);
        return this;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public RegisterTaskWithMaintenanceWindowRequest withMaxErrors(String maxErrors) {
        this.setMaxErrors(maxErrors);
        return this;
    }

    public void setLoggingInfo(LoggingInfo loggingInfo) {
        this.loggingInfo = loggingInfo;
    }

    public LoggingInfo getLoggingInfo() {
        return this.loggingInfo;
    }

    public RegisterTaskWithMaintenanceWindowRequest withLoggingInfo(LoggingInfo loggingInfo) {
        this.setLoggingInfo(loggingInfo);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RegisterTaskWithMaintenanceWindowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RegisterTaskWithMaintenanceWindowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public RegisterTaskWithMaintenanceWindowRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWindowId() != null) {
            sb.append("WindowId: ").append(this.getWindowId()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getTaskType() != null) {
            sb.append("TaskType: ").append(this.getTaskType()).append(",");
        }
        if (this.getTaskParameters() != null) {
            sb.append("TaskParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTaskInvocationParameters() != null) {
            sb.append("TaskInvocationParameters: ").append(this.getTaskInvocationParameters()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getMaxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(this.getMaxConcurrency()).append(",");
        }
        if (this.getMaxErrors() != null) {
            sb.append("MaxErrors: ").append(this.getMaxErrors()).append(",");
        }
        if (this.getLoggingInfo() != null) {
            sb.append("LoggingInfo: ").append(this.getLoggingInfo()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowRequest other = (RegisterTaskWithMaintenanceWindowRequest)obj;
        if (other.getWindowId() == null ^ this.getWindowId() == null) {
            return false;
        }
        if (other.getWindowId() != null && !other.getWindowId().equals(this.getWindowId())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getTaskType() == null ^ this.getTaskType() == null) {
            return false;
        }
        if (other.getTaskType() != null && !other.getTaskType().equals(this.getTaskType())) {
            return false;
        }
        if (other.getTaskParameters() == null ^ this.getTaskParameters() == null) {
            return false;
        }
        if (other.getTaskParameters() != null && !other.getTaskParameters().equals(this.getTaskParameters())) {
            return false;
        }
        if (other.getTaskInvocationParameters() == null ^ this.getTaskInvocationParameters() == null) {
            return false;
        }
        if (other.getTaskInvocationParameters() != null && !other.getTaskInvocationParameters().equals(this.getTaskInvocationParameters())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getMaxConcurrency() == null ^ this.getMaxConcurrency() == null) {
            return false;
        }
        if (other.getMaxConcurrency() != null && !other.getMaxConcurrency().equals(this.getMaxConcurrency())) {
            return false;
        }
        if (other.getMaxErrors() == null ^ this.getMaxErrors() == null) {
            return false;
        }
        if (other.getMaxErrors() != null && !other.getMaxErrors().equals(this.getMaxErrors())) {
            return false;
        }
        if (other.getLoggingInfo() == null ^ this.getLoggingInfo() == null) {
            return false;
        }
        if (other.getLoggingInfo() != null && !other.getLoggingInfo().equals(this.getLoggingInfo())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWindowId() == null ? 0 : this.getWindowId().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskType() == null ? 0 : this.getTaskType().hashCode());
        hashCode = 31 * hashCode + (this.getTaskParameters() == null ? 0 : this.getTaskParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTaskInvocationParameters() == null ? 0 : this.getTaskInvocationParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getMaxConcurrency() == null ? 0 : this.getMaxConcurrency().hashCode());
        hashCode = 31 * hashCode + (this.getMaxErrors() == null ? 0 : this.getMaxErrors().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingInfo() == null ? 0 : this.getLoggingInfo().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public RegisterTaskWithMaintenanceWindowRequest clone() {
        return (RegisterTaskWithMaintenanceWindowRequest)super.clone();
    }
}

