/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String queueUrl;
    private String label;
    private SdkInternalList<String> aWSAccountIds;
    private SdkInternalList<String> actions;

    public AddPermissionRequest() {
    }

    public AddPermissionRequest(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        this.setQueueUrl(queueUrl);
        this.setLabel(label);
        this.setAWSAccountIds(aWSAccountIds);
        this.setActions(actions);
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public AddPermissionRequest withQueueUrl(String queueUrl) {
        this.setQueueUrl(queueUrl);
        return this;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public AddPermissionRequest withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public List<String> getAWSAccountIds() {
        if (this.aWSAccountIds == null) {
            this.aWSAccountIds = new SdkInternalList();
        }
        return this.aWSAccountIds;
    }

    public void setAWSAccountIds(Collection<String> aWSAccountIds) {
        if (aWSAccountIds == null) {
            this.aWSAccountIds = null;
            return;
        }
        this.aWSAccountIds = new SdkInternalList(aWSAccountIds);
    }

    public AddPermissionRequest withAWSAccountIds(String ... aWSAccountIds) {
        if (this.aWSAccountIds == null) {
            this.setAWSAccountIds((Collection<String>)new SdkInternalList(aWSAccountIds.length));
        }
        for (String ele : aWSAccountIds) {
            this.aWSAccountIds.add((Object)ele);
        }
        return this;
    }

    public AddPermissionRequest withAWSAccountIds(Collection<String> aWSAccountIds) {
        this.setAWSAccountIds(aWSAccountIds);
        return this;
    }

    public List<String> getActions() {
        if (this.actions == null) {
            this.actions = new SdkInternalList();
        }
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new SdkInternalList(actions);
    }

    public AddPermissionRequest withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions((Collection<String>)new SdkInternalList(actions.length));
        }
        for (String ele : actions) {
            this.actions.add((Object)ele);
        }
        return this;
    }

    public AddPermissionRequest withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getLabel() != null) {
            sb.append("Label: " + this.getLabel() + ",");
        }
        if (this.getAWSAccountIds() != null) {
            sb.append("AWSAccountIds: " + this.getAWSAccountIds() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getAWSAccountIds() == null ^ this.getAWSAccountIds() == null) {
            return false;
        }
        if (other.getAWSAccountIds() != null && !other.getAWSAccountIds().equals(this.getAWSAccountIds())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        return other.getActions() == null || other.getActions().equals(this.getActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getAWSAccountIds() == null ? 0 : this.getAWSAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        return hashCode;
    }

    public AddPermissionRequest clone() {
        return (AddPermissionRequest)super.clone();
    }
}

