/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.EncryptionAlgorithm;
import com.amazonaws.services.signer.model.HashAlgorithm;
import com.amazonaws.services.signer.model.transform.SigningConfigurationOverridesMarshaller;
import java.io.Serializable;

public class SigningConfigurationOverrides
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionAlgorithm;
    private String hashAlgorithm;

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public SigningConfigurationOverrides withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.setEncryptionAlgorithm(encryptionAlgorithm);
        return this;
    }

    public SigningConfigurationOverrides withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm.toString();
        return this;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public SigningConfigurationOverrides withHashAlgorithm(String hashAlgorithm) {
        this.setHashAlgorithm(hashAlgorithm);
        return this;
    }

    public SigningConfigurationOverrides withHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionAlgorithm() != null) {
            sb.append("EncryptionAlgorithm: ").append(this.getEncryptionAlgorithm()).append(",");
        }
        if (this.getHashAlgorithm() != null) {
            sb.append("HashAlgorithm: ").append(this.getHashAlgorithm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfigurationOverrides)) {
            return false;
        }
        SigningConfigurationOverrides other = (SigningConfigurationOverrides)obj;
        if (other.getEncryptionAlgorithm() == null ^ this.getEncryptionAlgorithm() == null) {
            return false;
        }
        if (other.getEncryptionAlgorithm() != null && !other.getEncryptionAlgorithm().equals(this.getEncryptionAlgorithm())) {
            return false;
        }
        if (other.getHashAlgorithm() == null ^ this.getHashAlgorithm() == null) {
            return false;
        }
        return other.getHashAlgorithm() == null || other.getHashAlgorithm().equals(this.getHashAlgorithm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionAlgorithm() == null ? 0 : this.getEncryptionAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getHashAlgorithm() == null ? 0 : this.getHashAlgorithm().hashCode());
        return hashCode;
    }

    public SigningConfigurationOverrides clone() {
        try {
            return (SigningConfigurationOverrides)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningConfigurationOverridesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

