/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.CreateTemplateRequest;
import com.amazonaws.services.simpleemail.model.Template;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTemplateRequestMarshaller
implements Marshaller<Request<CreateTemplateRequest>, CreateTemplateRequest> {
    public Request<CreateTemplateRequest> marshall(CreateTemplateRequest createTemplateRequest) {
        if (createTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTemplateRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        Template template = createTemplateRequest.getTemplate();
        if (template != null) {
            if (template.getTemplateName() != null) {
                request.addParameter("Template.TemplateName", StringUtils.fromString((String)template.getTemplateName()));
            }
            if (template.getSubjectPart() != null) {
                request.addParameter("Template.SubjectPart", StringUtils.fromString((String)template.getSubjectPart()));
            }
            if (template.getTextPart() != null) {
                request.addParameter("Template.TextPart", StringUtils.fromString((String)template.getTextPart()));
            }
            if (template.getHtmlPart() != null) {
                request.addParameter("Template.HtmlPart", StringUtils.fromString((String)template.getHtmlPart()));
            }
        }
        return request;
    }
}

