/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListIdentitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<String> identities;
    private String nextToken;

    public List<String> getIdentities() {
        if (this.identities == null) {
            this.identities = new SdkInternalList();
        }
        return this.identities;
    }

    public void setIdentities(Collection<String> identities) {
        if (identities == null) {
            this.identities = null;
            return;
        }
        this.identities = new SdkInternalList(identities);
    }

    public ListIdentitiesResult withIdentities(String ... identities) {
        if (this.identities == null) {
            this.setIdentities((Collection<String>)new SdkInternalList(identities.length));
        }
        for (String ele : identities) {
            this.identities.add((Object)ele);
        }
        return this;
    }

    public ListIdentitiesResult withIdentities(Collection<String> identities) {
        this.setIdentities(identities);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIdentitiesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentities() != null) {
            sb.append("Identities: ").append(this.getIdentities()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResult)) {
            return false;
        }
        ListIdentitiesResult other = (ListIdentitiesResult)obj;
        if (other.getIdentities() == null ^ this.getIdentities() == null) {
            return false;
        }
        if (other.getIdentities() != null && !other.getIdentities().equals(this.getIdentities())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentities() == null ? 0 : this.getIdentities().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListIdentitiesResult clone() {
        try {
            return (ListIdentitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

