/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servicediscovery.model.RecordType;
import com.amazonaws.services.servicediscovery.model.transform.DnsRecordMarshaller;
import java.io.Serializable;

public class DnsRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Long tTL;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public DnsRecord withType(String type) {
        this.setType(type);
        return this;
    }

    public DnsRecord withType(RecordType type) {
        this.type = type.toString();
        return this;
    }

    public void setTTL(Long tTL) {
        this.tTL = tTL;
    }

    public Long getTTL() {
        return this.tTL;
    }

    public DnsRecord withTTL(Long tTL) {
        this.setTTL(tTL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getTTL() != null) {
            sb.append("TTL: ").append(this.getTTL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord other = (DnsRecord)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getTTL() == null ^ this.getTTL() == null) {
            return false;
        }
        return other.getTTL() == null || other.getTTL().equals(this.getTTL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getTTL() == null ? 0 : this.getTTL().hashCode());
        return hashCode;
    }

    public DnsRecord clone() {
        try {
            return (DnsRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

